package edu.uky.ai;

/**
 * Indicates that an algorithm has performed more than the maximum allowed
 * number of operations.
 * 
 * @author Stephen G. Ware
 */
public class OperationsBudgetExceededException extends SearchBudgetExceededException {
	
	private static final long serialVersionUID = 1L;

	/**
	 * Constructs a new exception with a given message.
	 * 
	 * @param message the message explaining what caused the exception
	 */
	OperationsBudgetExceededException(String message) {
		super(message);
	}
	
	/**
	 * Constructs a new exception with a default message.
	 */
	OperationsBudgetExceededException() {
		this("Search operations exceeded.");
	}
}
