package edu.uky.ai.planning.ss;

import edu.uky.ai.SearchBudget;
import edu.uky.ai.planning.Search;

/**
 * Represents a search through the space of states.
 * 
 * @author Stephen G. Ware
 */
public abstract class StateSpaceSearch extends Search {

	/** The state space problem being solved */
	public final StateSpaceProblem problem;
	
	/** The root node of the search space (i.e. a plan with 0 steps) */
	public final StateSpaceRoot root;
	
	/**
	 * Creates a state space search for a given problem.
	 * 
	 * @param problem the problem whose state space will be searched
	 * @param budget the maximum number of states that may be searched and the
	 * @param root the root node of the search space
	 * maximum number of milliseconds the search may take
	 */
	public StateSpaceSearch(StateSpaceProblem problem, SearchBudget budget, StateSpaceRoot root) {
		super(problem, budget);
		this.problem = problem;
		this.root = root;
	}
}
