package edu.uky.ai.planning.ss;

import edu.uky.ai.planning.Plan;

/**
 * Represents a node in a state space search graph.  A node is considered
 * generated once it is created.  A node is considered visited once it has
 * one or more children.
 * 
 * @author Stephen G. Ware
 */
public interface StateSpaceNode {
	
	/**
	 * Returns the root node of the search space.
	 * 
	 * @return the root
	 */
	public StateSpaceNode getRoot();
	
	/**
	 * Returns the plan this node represents.
	 * 
	 * @return the plan
	 */
	public Plan getPlan();
}
