package edu.uky.ai.planning.ss;

import edu.uky.ai.SearchBudget;

/**
 * Represents a forward search through the space of states, starting at the
 * initial state and ending in any state where the goal is achieved. In the
 * graph defined by this search, {@link ForwardNode nodes} are states and edges
 * are {@link edu.uky.ai.planning.Step steps}.
 * 
 * @author Stephen G. Ware
 */
public abstract class ForwardSearch extends StateSpaceSearch {
	
	/** The root node of the search space (i.e. a plan with 0 steps) */
	public final ForwardRoot root;
	
	/**
	 * Creates a forward state space search for a given problem.
	 * 
	 * @param problem the problem whose state space will be searched
	 * @param budget the maximum number of states that may be searched and the
	 * maximum number of milliseconds the search may take
	 */
	public ForwardSearch(StateSpaceProblem problem, SearchBudget budget) {
		super(problem, budget, new ForwardRoot(problem, budget));
		this.root = (ForwardRoot) super.root;
	}

	@Override
	public int countVisited() {
		return root.visited;
	}

	@Override
	public int countGenerated() {
		return root.generated;
	}
}
