package edu.uky.ai.planning.ss;

import edu.uky.ai.planning.Heuristic;

/**
 * A wrapper around a {@link StateSpaceHeuristic} which uses the given
 * heuristic to estimate the distance from the current state in a
 * {@link ForwardSearch forward search} to the problem's goal.
 * 
 * @author Stephen G. Ware
 */
public class ForwardHeuristic implements Heuristic<ForwardNode> {

	/** The heuristic to use */
	public final StateSpaceHeuristic heuristic;
	
	/**
	 * Constructs a new forward heuristic.
	 * 
	 * @param heuristic the state space heuristic to use
	 */
	public ForwardHeuristic(StateSpaceHeuristic heuristic) {
		this.heuristic = heuristic;
	}
	
	@Override
	public double evaluate(ForwardNode node) {
		StateSpaceProblem problem = node.getRoot().problem;
		return heuristic.evaluate(problem, node.state, problem.goal);
	}
}
