package edu.uky.ai.planning.ss;

import edu.uky.ai.SearchBudget;
import edu.uky.ai.planning.Problem;

/**
 * A planner which searches backward through space of states for the solution to
 * a given problem.
 * 
 * @author Stephen G. Ware
 */
public abstract class BackwardPlanner extends StateSpacePlanner<BackwardSearch> {

	/**
	 * Constructs a new backward state space planner with a given name.
	 * 
	 * @param name the name of the planner
	 */
	public BackwardPlanner(String name) {
		super(name);
	}

	@Override
	protected BackwardSearch makeSearch(Problem problem, SearchBudget budget) {
		return makeStateSpaceSearch(new StateSpaceProblem(problem), budget);
	}
	
	@Override
	protected BackwardSearch makeStateSpaceSearch(StateSpaceProblem problem, SearchBudget budget) {
		return makeBackwardSearch(problem, budget);
	}
	
	/**
	 * Given some state space problem to be solved, this method constructs the
	 * appropriate kind of {@link BackwardSearch} to solve it based on this
	 * planner.
	 * 
	 * @param problem the state space problem to be solved
	 * @param budget the search budget in which to solve it
	 * @return a backward state space search object for solving this problem
	 */
	protected abstract BackwardSearch makeBackwardSearch(StateSpaceProblem problem, SearchBudget budget);
}
