package edu.uky.ai.planning.ss;

import edu.uky.ai.planning.Heuristic;

/**
 * A wrapper around a {@link StateSpaceHeuristic} which uses the given
 * heuristic to estimate the distance from the problem's initial state to the
 * current goal of a {@link BackwardSearch backward search}.
 * 
 * @author Stephen G. Ware
 */
public class BackwardHeuristic implements Heuristic<BackwardNode> {

	/** The heuristic to use */
	public final StateSpaceHeuristic heuristic;
	
	/**
	 * Constructs a new backward heuristic.
	 * 
	 * @param heuristic the state space heuristic to use
	 */
	public BackwardHeuristic(StateSpaceHeuristic heuristic) {
		this.heuristic = heuristic;
	}
	
	@Override
	public double evaluate(BackwardNode node) {
		StateSpaceProblem problem = node.getRoot().problem;
		return heuristic.evaluate(problem, problem.initial, node.goal);
	}
}
