package edu.uky.ai.planning.ps;

import edu.uky.ai.logic.Substitution;

/**
 * An threatened causal link flaw indicates that a partial plan contains a
 * causal link such that the effect of its tail step might be undone by some
 * other step in the plan (the threat) before it is used by the causal link's
 * tail step.
 * 
 * @author Stephen G. Ware
 */
public class ThreatenedCausalLinkFlaw extends Flaw {

	/** The threatened causal link */
	public final CausalLink link;
	
	/** The threatening step */
	public final PartialStep threat;
	
	/**
	 * Constructs a new threatened causal link flaw for the given causal link
	 * and threatening step.
	 * 
	 * @param link the threatened causal link
	 * @param threat the threatening step
	 */
	public ThreatenedCausalLinkFlaw(CausalLink link, PartialStep threat) {
		this.link = link;
		this.threat = threat;
	}

	@Override
	public String toString(Substitution substitution) {
		return threat.toString(substitution) + " threatens " + link.toString(substitution);
	}
}
