package edu.uky.ai.planning.ps;
import edu.uky.ai.SearchBudget;
import edu.uky.ai.planning.Problem;

/**
 * A special subclass of {@link PlanSpaceNode} representing the root node of
 * the search space.
 * 
 * @author Stephen G. Ware
 */
public class PlanSpaceRoot extends PlanSpaceNode {

	/** The problem this search is trying to solve */
	public final Problem problem;
	
	/** The search budget */
	public final SearchBudget budget;
	
	/** Number of nodes visited in this space */
	int visited = 0;
	
	/** Number of nodes generated in this space */
	int generated = 1;
	
	/**
	 * Constructs a new root node of a search space for a given problem.
	 * 
	 * @param problem the problem to solve
	 * @param budget budget the search budget, which limits how many nodes may
	 * be visited and how much time may be spent solving the problem
	 */
	public PlanSpaceRoot(Problem problem, SearchBudget budget) {
		super(problem);
		this.problem = problem;
		this.budget = budget;
	}
}
