package edu.uky.ai.planning.ps;

import edu.uky.ai.logic.ListBindings;
import edu.uky.ai.logic.Literal;
import edu.uky.ai.logic.Substitution;

/**
 * An open precondition flaw indicates that a partial plan has not yet
 * guaranteed that some precondition of some step will be satisfied.
 * 
 * @author Stephen G. Ware
 */
public class OpenPreconditionFlaw extends Flaw {

	/** The step for which some precondition has not been satisfied */
	public final PartialStep step;
	
	/** The precondition of the step that needs to be satisfied */
	public final Literal precondition;
	
	/**
	 * Constructs a new open precondition flaw for a given step and
	 * precondition.
	 * 
	 * @param step the step for which a precondition has not yet been satisfied
	 * @param precondition the precondition of the step which needs to be satisfied
	 */
	public OpenPreconditionFlaw(PartialStep step, Literal precondition) {
		this.step = step;
		this.precondition = precondition;
	}
	
	@Override
	public String toString() {
		return toString(ListBindings.EMPTY);
	}

	@Override
	public String toString(Substitution substitution) {
		return precondition.substitute(substitution) + " open for " + step.toString(substitution);
	}
}
