package edu.uky.ai.planning.pg;

import edu.uky.ai.SearchBudget;

/**
 * A special subclass of {@link SubgraphSpaceNode} representing the root node
 * of the search space.
 * 
 * @author Stephen G. Ware
 */
public class SubgraphSpaceRoot extends SubgraphSpaceNode {
	
	/** The plan graph being searched */
	public final PlanGraph graph;
	
	/** The search budget */
	public final SearchBudget budget;
	
	/** The number of nodes visited in this search space */
	int visited = 0;
	
	/** The number of nodes generated in this search space */
	int generated = 1;
	
	/**
	 * Constructs a new subgraph root node for the given plan graph and
	 * subgraph.
	 * 
	 * @param graph the plan graph
	 * @param subgraph a subset of nodes from the plan graph
	 */
	SubgraphSpaceRoot(PlanGraph graph, SearchBudget budget, Subgraph subgraph) {
		super(null, subgraph);
		this.graph = graph;
		this.budget = budget;
	}
}
