package edu.uky.ai.planning.pg;

/**
 * This class represents a specific subgraph of a plan graph during the search
 * for a subgraph which represents a solution to the problem.
 * 
 * @author Stephen G. Ware
 */
public class SubgraphSpaceNode {

	/** This node's parent */
	public SubgraphSpaceNode parent;
	
	/** A subset of nodes from the plan graph */
	public final Subgraph subgraph;
	
	/** Indicates whether or not any of this node's children have been expanded */
	private boolean visited = false;
	
	/**
	 * Constructs a new subgraph space node with the given parent and subgraph.
	 * 
	 * @param parent this node's parent node
	 * @param subgraph the plan graph nodes in this subgraph
	 */
	SubgraphSpaceNode(SubgraphSpaceNode parent, Subgraph subgraph) {
		this.parent = parent;
		this.subgraph = subgraph;
		SubgraphSpaceRoot root = getRoot();
		if(parent != null && !parent.visited) {
			root.budget.incrementOperations();
			root.budget.checkTime();
			parent.visited = true;
			root.visited++;
		}
		root.generated++;
	}
	
	@Override
	public String toString() {
		return "===== SUBGRAPH SPACE NODE =====\n" + subgraph;
	}
	
	/**
	 * Returns the root node of this search space.
	 * 
	 * @return the root node
	 */
	public SubgraphSpaceRoot getRoot() {
		SubgraphSpaceNode current = this;
		while(current.parent != null)
			current = current.parent;
		return (SubgraphSpaceRoot) current;
	}
	
	/**
	 * Creates a child subgraph space node (a node for which this node is the
	 * parent) with the given subgraph.
	 * 
	 * @param subgraph a subset of nodes from the plan graph
	 * @return the child node
	 */
	public SubgraphSpaceNode expand(Subgraph subgraph) {
		return new SubgraphSpaceNode(this, subgraph);
	}
}
