package edu.uky.ai.planning.pg;

import java.util.Iterator;

/**
 * Represents a specific level of a {@link PlanGraph}, and contains only those
 * nodes which exist at this level.
 * 
 * @author Stephen G. Ware
 */
public class Level {

	/** The index of this level */
	public final int number;
	
	/** The previous level in this graph */
	public final Level previous;
	
	/** The graph to which this level belongs */
	protected final PlanGraph graph;
	
	/**
	 * Constructs a new level object.
	 * 
	 * @param graph the graph in which this level exists
	 * @param number the level's index
	 */
	protected Level(PlanGraph graph, int number) {
		this.graph = graph;
		this.number = number;
		this.previous = number == 0 ? null : graph.getLevel(number - 1);
	}

	/**
	 * All literal nodes which exist at this level.
	 */
	public Iterable<LiteralNode> literals = new Iterable<LiteralNode>() {
		@Override
		public Iterator<LiteralNode> iterator() {
			return new NodeIterator<LiteralNode>(number, graph.literalMap.values());
		}
	};
	
	/**
	 * All step nodes which exist at this level.
	 */
	public Iterable<StepNode> steps = new Iterable<StepNode>() {
		@Override
		public Iterator<StepNode> iterator() {
			return new NodeIterator<StepNode>(number, graph.stepMap.values());
		}
	};
	
	/**
	 * Computes non-static mutexes for this level.
	 */
	final void computeMutexes() {
		// not implemented
	}
}
