package edu.uky.ai.planning;

import edu.uky.ai.SearchBudget;

/**
 * A search is the process of exploring some space while looking for solutions
 * to a problem.  There are many different kinds of search spaces.  Note that
 * if a search space contains any solutions it probably contains many
 * solutions, so this class provides ways to get one solution after another.
 * 
 * @author Stephen G. Ware
 */
public abstract class Search {

	/** The problem being solved */
	public final Problem problem;
	
	/** The search budget for this problem */
	public final SearchBudget budget;
	
	/**
	 * Constructs a new search for the given problem.
	 * 
	 * @param problem the problem to be solved
	 * @param budget the search budget
	 */
	public Search(Problem problem, SearchBudget budget) {
		this.problem = problem;
		this.budget = budget;
	}
	
	/**
	 * Returns the total number of nodes that have been visited in this search
	 * space since it was created.
	 * 
	 * @return the number of visited nodes
	 */
	public abstract int countVisited();
	
	/**
	 * Returns the total number of nodes that have been generated in this
	 * search since it was created.
	 * 
	 * @return the number of expanded ndoes
	 */
	public abstract int countGenerated();
	
	/**
	 * Searches the space until a solution is found.
	 * 
	 * @return the solution found
	 */
	public abstract Plan solve();
}
