package edu.uky.ai.logic.io;

import edu.uky.ai.io.Node;
import edu.uky.ai.io.ObjectParser;
import edu.uky.ai.io.Parser;
import edu.uky.ai.logic.Atom;
import edu.uky.ai.logic.AtomicProposition;
import edu.uky.ai.logic.Proposition;

/**
 * A parser for propositional logic, which expects all {@link Atom}s to be
 * {@link AtomicProposition}s.
 * 
 * @author Stephen G. Ware
 */
public class PropositionalLogicParser extends LogicParser {
	
	/**
	 * Constructs a new parser with rules for parsing propositional logic
	 * formulas.
	 */
	public PropositionalLogicParser() {
		setParser(Atom.class, ATOM_PARSER);
		setParser(AtomicProposition.class, ATOMIC_PROPOSITION_PARSER);
	}
	
	/** Parses atoms */
	private static final ObjectParser<Atom> ATOM_PARSER = new ObjectParser<Atom>() {

		@Override
		public Atom parse(Node node, Parser parser) {
			if(node.isSymbol(Proposition.TRUE.toString()))
				return Proposition.TRUE;
			else if(node.isSymbol(Proposition.FALSE.toString()))
				return Proposition.FALSE;
			else
				return parser.parse(node, AtomicProposition.class);
		}
	};
	
	/** Parses predications */
	private static final ObjectParser<AtomicProposition> ATOMIC_PROPOSITION_PARSER = new ObjectParser<AtomicProposition>() {

		@Override
		public AtomicProposition parse(Node node, Parser parser) {
			return new AtomicProposition(node.asSymbol().value);
		}
	};
}
