package edu.uky.ai.logic;

import edu.uky.ai.util.ImmutableArray;

/**
 * The {@link Negation negation} of an {@link Atom}.
 * 
 * @author Stephen G. Ware
 */
public class NegatedAtom extends Negation implements Literal {

	/** The atom which this proposition negates */
	public final Atom argument;
	
	/**
	 * Constructs a new negated atom with a given atom.
	 * 
	 * @param argument the atom to negate
	 */
	public NegatedAtom(Atom argument) {
		super(argument);
		this.argument = argument;
	}
	
	@Override
	public Literal substitute(Substitution substitution) {
		ImmutableArray<Proposition> arguments = substituteArguments(substitution);
		if(arguments == this.arguments)
			return (Literal) substitution.get(this);
		else
			return (Literal) substitution.get(new NegatedAtom((Atom) arguments.get(0)));
	}
	
	@Override
	public void makeTrue(MutableState state) {
		state.remove(argument);
	}
	
	@Override
	public Literal negate() {
		return argument;
	}

	@Override
	public Literal toCNF() {
		return this;
	}

	@Override
	public Literal toDNF() {
		return this;
	}
}
