package edu.uky.ai.logic;

import java.util.HashMap;

/**
 * A substitution which uses a {@link java.util.HashMap} to keep track of
 * substitutions.
 * 
 * @author Stephen G. Ware
 */
public class HashSubstitution implements Substitution, Cloneable {

	/** The map used to keep track of substitutions */
	private final HashMap<Formula, Formula> map;
	
	/**
	 * Constructs a new hash substitution which is a clone of the given
	 * substitution.
	 * 
	 * @param toClone the substitution to clone
	 */
	protected HashSubstitution(HashSubstitution toClone) {
		this.map = toClone.map;
	}
	
	/**
	 * Constructs a new, empty hash substitution.
	 */
	public HashSubstitution() {
		this.map = new HashMap<>();
	}
	
	@Override
	public Formula get(Formula original) {
		Formula replacement = original;
		while(map.containsKey(replacement))
			replacement = map.get(replacement);
		return replacement;
	}
	
	/**
	 * Specifies that a given formula should be replaced with another formula.
	 * 
	 * @param original the formula to be replaced
	 * @param replacement the formula that will replace it
	 */
	public void set(Formula original, Formula replacement) {
		map.put(original, replacement);
	}
	
	@Override
	public HashSubstitution clone() {
		return new HashSubstitution(this);
	}
}