package edu.uky.ai.logic;

/**
 * A set of assignments of values to {@link Term} terms. A set of bindings can
 * reason about which terms are equal (have the same value) and which are not
 * equal (have different values).
 * 
 * A set of bindings must be consistent, meaning it may not contains any
 * contradictions (e.g. two terms are both equal and not equal).
 * 
 * Bindings data structures may or may not be immutable (meaning operations
 * that would modify the structure return a new structure instead). All methods
 * which modify a set of bindings return a set of bindings; these methods may
 * or may not modify the original structure. Thus, if you do not know whether
 * a particular set of bindings is immutable or not, you should treat it as if
 * it were immutable, just in case.
 * 
 * @author Stephen G. Ware
 */
public interface Bindings extends Substitution {

	/**
	 * Declares that two terms must have the same value.
	 * 
	 * @param t1 the first term
	 * @param t2 the second term
	 * @return a set of bindings in which both terms must have the same value,
	 * or null if such a set would contain a contradiction
	 */
	public Bindings setEqual(Term t1, Term t2);
	
	/**
	 * Declares that two terms must have different values.
	 * 
	 * @param t1 the first term
	 * @param t2 the second term
	 * @return a set of bindings in which both terms must have different
	 * values, or null if such a set would contain a contradiction
	 */
	public Bindings setNotEqual(Term t1, Term t2);
}
