package edu.uky.ai.logic;

/**
 * An individual statement that has a truth value (the atoms of propositional
 * logic).
 * 
 * @author Stephen G. Ware
 */
public class AtomicProposition implements Atom {
	
	/** The proposition's name */
	public final String name;
	
	/**
	 * Constructs a new atom with the given name.
	 * 
	 * @param name the atom's name
	 */
	public AtomicProposition(String name) {
		this.name = name;
	}
	
	@Override
	public boolean equals(Object other) {
		return other instanceof AtomicProposition && name.equals(((AtomicProposition) other).name);
	}
	
	@Override
	public int hashCode() {
		return name.hashCode();
	}
	
	@Override
	public String toString() {
		return name;
	}
	
	@Override
	public boolean isGround() {
		return true;
	}
	
	@Override
	public Atom substitute(Substitution substitution) {
		return (Atom) substitution.get(this);
	}

	@Override
	public Bindings unify(Formula other, Bindings bindings) {
		if(this.equals(other, bindings))
			return bindings;
		else
			return null;
	}
}
