package edu.uky.ai.util;

/**
 * Represents a single directed egde in a {@link DirectedAcyclicGraph}.
 * 
 * @author Stephen G. Ware
 * @param <T> the type of object used as nodes in the DAG
 */
public class DirectedEdge<T> {

	/** The first or 'before' object */
	public final T tail;
	
	/** The second of 'after' object */
	public final T head;
	
	/**
	 * Constructs a new directed edge with the given tail and head.
	 * 
	 * @param tail the tail node
	 * @param head the head node
	 */
	DirectedEdge(T tail, T head) {
		this.tail = tail;
		this.head = head;
	}
	
	@Override
	public String toString() {
		return tail + " < " + head;
	}
}
