package edu.uky.ai.sat;

import edu.uky.ai.logic.Atom;
import edu.uky.ai.util.ImmutableArray;

/**
 * Represents one of the unique variables that appears somewhere in the formula
 * of a satisfiability {@link Problem}. A variable can have one of three
 * {@link Value}s in an {@link Assignment}: true, false, or unknown.
 * 
 * @author Stephen G. Ware
 */
public class Variable {

	/** The problem this variable is associated with */
	public final Problem problem;
	
	/** The number of the variable */
	public final int index;
	
	/** The logical formula this variable was created from */
	public final Atom proposition;
	
	/** A list of all the literals this variable appears in */
	public final ImmutableArray<Literal> literals;
	
	private int hashCode;
	
	Variable(Problem problem, int index, Atom proposition, Literal[] literals) {
		this.problem = problem;
		this.index = index;
		this.proposition = proposition;
		this.literals = new ImmutableArray<>(literals);
		this.hashCode = proposition.hashCode();
	}
	
	@Override
	public int hashCode() {
		return hashCode;
	}
	
	@Override
	public String toString() {
		return proposition.toString();
	}
	
	/**
	 * Returns a string representation of the variable after substituting its
	 * value, if is is known, and simplifying the formula.
	 * 
	 * @param assignment an assignment that defines which variables have known
	 * values
	 * @return a string representation of the variable
	 */
	public String toString(Assignment assignment) {
		return proposition.substitute(assignment).simplify().toString();
	}
}
