package edu.uky.ai.sat;

/**
 * Represents one literal in a disjunctive {@link Clause}. A literal involves
 * exactly one {@link Variable} and its valence can be either positive (the
 * variable by itself) of negative (the negation of the variable).
 * 
 * @author Stephen G. Ware
 */
public class Literal {

	/** The {@link Clause} this literal appears in */
	public final Clause clause;
	
	/** The proposition this clause was created from */
	public final edu.uky.ai.logic.Literal proposition;
	
	/** The valence of this literal (true for positive, false for negative */
	public final boolean valence;
	
	/** The variable that makes up this literal */
	public final Variable variable;
	
	private final int hashCode;
	
	Literal(Clause clause, edu.uky.ai.logic.Literal proposition, boolean valence, Variable variable) {
		this.clause = clause;
		this.proposition = proposition;
		this.valence = valence;
		this.variable = variable;
		this.hashCode = proposition.hashCode();
	}
	
	@Override
	public int hashCode() {
		return hashCode;
	}
	
	@Override
	public String toString() {
		return proposition.toString();
	}
	
	/**
	 * Returns a string representation of the literal after substituting the
	 * value of the variable if it is known and simplifying the formula.
	 * 
	 * @param assignment an assignment that defines which variables have known
	 * values
	 * @return a string representation of the literal
	 */
	public String toString(Assignment assignment) {
		return proposition.substitute(assignment).simplify().toString();
	}
}
