package edu.uky.ai.logic;

/**
 * A state which can be modified.
 * 
 * @author Stephen G. Ware
 */
public interface MutableState extends State {

	/**
	 * Makes a new atom true in this state.
	 * 
	 * @param atom the atom to make true
	 */
	public void add(Atom atom);
	
	/**
	 * Makes a new atom false in this state.
	 * 
	 * @param atom the atom to make false
	 */
	public void remove(Atom atom);
}
