package edu.uky.ai.logic;

/**
 * An atom is the smallest indivisible unit of a logical language that has a
 * truth value.
 * 
 * @author Stephen G. Ware
 */
public interface Atom extends Literal {

	@Override
	public Atom substitute(Substitution substitution);
	
	@Override
	public default boolean isTrue(State state) {
		return state.contains(this);
	}

	@Override
	public default void makeTrue(MutableState state) {
		state.add(this);
	}
	
	@Override
	public default Atom simplify() {
		return this;
	}

	@Override
	public default Literal negate() {
		return new NegatedAtom(this);
	}
}
