/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTypeContribution;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class LaunchHistory
implements ILaunchListener,
ILaunchConfigurationListener {
    private final Vector<ILaunchConfiguration> fCompleteHistory = new Vector();
    private final ILaunchGroup fGroup;
    private List<ILaunchConfiguration> fFavorites = new ArrayList<ILaunchConfiguration>();
    private boolean fSaved = true;
    private static List<LaunchHistory> fgLaunchHistoryInstances = new ArrayList<LaunchHistory>();

    public LaunchHistory(ILaunchGroup group) {
        this.fGroup = group;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        manager.addLaunchListener((ILaunchListener)this);
        manager.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        fgLaunchHistoryInstances.add(this);
    }

    public void dispose() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        manager.removeLaunchListener((ILaunchListener)this);
        manager.removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        fgLaunchHistoryInstances.remove(this);
    }

    public void launchAdded(ILaunch launch) {
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        if (configuration != null && !configuration.isWorkingCopy() && DebugUIPlugin.doLaunchConfigurationFiltering(configuration) && this.accepts(configuration)) {
            this.addHistory(configuration, true);
        }
    }

    public synchronized boolean contains(ILaunchConfiguration configuration) {
        return this.fCompleteHistory.contains(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHistory(ILaunchConfiguration configuration, boolean prepend) {
        LaunchHistory launchHistory = this;
        synchronized (launchHistory) {
            if (configuration.isWorkingCopy()) {
                return;
            }
            this.checkFavorites(configuration);
            int index = this.fCompleteHistory.indexOf(configuration);
            if (index == 0) {
                return;
            }
            if (index < 0) {
                if (prepend) {
                    this.fCompleteHistory.add(0, configuration);
                } else {
                    this.fCompleteHistory.add(configuration);
                }
            } else {
                this.fCompleteHistory.add(0, this.fCompleteHistory.remove(index));
            }
            this.resizeHistory();
        }
        this.fireLaunchHistoryChanged();
    }

    private void fireLaunchHistoryChanged() {
        DebugUIPlugin.getDefault().getLaunchConfigurationManager().fireLaunchHistoryChanged();
        this.setSaved(false);
    }

    public boolean needsSaving() {
        return !this.fSaved;
    }

    public void setSaved(boolean saved) {
        this.fSaved = saved;
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }

    public synchronized ILaunchConfiguration getRecentLaunch() {
        ILaunchConfiguration[] history = this.getCompleteLaunchHistory();
        if (history.length > 0) {
            return history[0];
        }
        return null;
    }

    public synchronized ILaunchConfiguration[] getHistory() {
        Vector<ILaunchConfiguration> history = new Vector<ILaunchConfiguration>();
        try {
            for (ILaunchConfiguration config : this.fCompleteHistory) {
                if (!config.exists() || this.fFavorites.contains(config) || !DebugUIPlugin.doLaunchConfigurationFiltering(config) || WorkbenchActivityHelper.filterItem((Object)new LaunchConfigurationTypeContribution(config.getType()))) continue;
                history.add(config);
            }
            if (history.size() > this.getMaxHistorySize()) {
                history.setSize(this.getMaxHistorySize());
            }
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        return history.toArray(new ILaunchConfiguration[history.size()]);
    }

    public synchronized ILaunchConfiguration[] getCompleteLaunchHistory() {
        ArrayList<ILaunchConfiguration> history = new ArrayList<ILaunchConfiguration>();
        try {
            for (ILaunchConfiguration config : this.fCompleteHistory) {
                if (!config.exists() || !DebugUIPlugin.doLaunchConfigurationFiltering(config) || WorkbenchActivityHelper.filterItem((Object)new LaunchConfigurationTypeContribution(config.getType()))) continue;
                history.add(config);
            }
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        return history.toArray(new ILaunchConfiguration[history.size()]);
    }

    public synchronized ILaunchConfiguration[] getFavorites() {
        return this.fFavorites.toArray(new ILaunchConfiguration[this.fFavorites.size()]);
    }

    public synchronized void setFavorites(ILaunchConfiguration[] favorites) {
        this.fFavorites = new Vector<ILaunchConfiguration>(Arrays.asList(favorites));
        this.setSaved(false);
        this.fireLaunchHistoryChanged();
    }

    public synchronized void addFavorite(ILaunchConfiguration configuration) {
        if (!this.fFavorites.contains(configuration)) {
            this.fFavorites.add(configuration);
            this.setSaved(false);
            this.fireLaunchHistoryChanged();
        }
    }

    public ILaunchGroup getLaunchGroup() {
        return this.fGroup;
    }

    public boolean accepts(ILaunchConfiguration configuration) {
        block5: {
            if (LaunchConfigurationManager.isVisible(configuration)) break block5;
            return false;
        }
        try {
            if (configuration.getType().supportsMode(this.getLaunchGroup().getMode())) {
                String launchCategory = null;
                launchCategory = configuration.getCategory();
                String category = this.getLaunchGroup().getCategory();
                if (launchCategory == null || category == null) {
                    return launchCategory == category;
                }
                return category.equals(launchCategory);
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        return false;
    }

    public static void launchHistoryChanged() {
        for (LaunchHistory history : fgLaunchHistoryInstances) {
            history.resizeHistory();
        }
    }

    protected synchronized void resizeHistory() {
        int max = this.getMaxHistorySize() + this.fFavorites.size();
        if (this.fCompleteHistory.size() > max) {
            this.fCompleteHistory.setSize(max);
        }
    }

    protected int getMaxHistorySize() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.debug.ui.max_history_size");
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        ILaunchConfiguration movedFrom = DebugPlugin.getDefault().getLaunchManager().getMovedFrom(configuration);
        if (movedFrom == null) {
            this.checkFavorites(configuration);
        }
    }

    protected boolean isFavorite(ILaunchConfiguration configuration) throws CoreException {
        String groupId = this.getLaunchGroup().getIdentifier();
        List favoriteGroups = configuration.getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
        if (favoriteGroups == null) {
            if (groupId.equals("org.eclipse.debug.ui.launchGroup.debug")) {
                return configuration.getAttribute("org.eclipse.debug.ui.debugFavorite", false);
            }
            if (groupId.equals("org.eclipse.debug.ui.launchGroup.run")) {
                return configuration.getAttribute("org.eclipse.debug.ui.runFavorite", false);
            }
        } else if (favoriteGroups.contains(this.getLaunchGroup().getIdentifier())) {
            return true;
        }
        return false;
    }

    protected boolean checkFavorites(ILaunchConfiguration configuration) {
        block4: {
            if (configuration.isWorkingCopy()) {
                return false;
            }
            try {
                if (!this.isFavorite(configuration)) break block4;
                this.addFavorite(configuration);
                return true;
            }
            catch (CoreException coreException) {
                this.removeFavorite(configuration);
                return false;
            }
        }
        this.removeFavorite(configuration);
        return false;
    }

    protected synchronized void removeFavorite(ILaunchConfiguration configuration) {
        this.fFavorites.remove(configuration);
        this.setSaved(false);
        this.fireLaunchHistoryChanged();
    }

    public synchronized void removeFromHistory(ILaunchConfiguration configuration) {
        try {
            boolean removed = this.fCompleteHistory.remove(configuration);
            if (this.isFavorite(configuration)) {
                removed |= this.fFavorites.remove(configuration);
            }
            if (removed) {
                this.setSaved(false);
                this.fireLaunchHistoryChanged();
            }
        }
        catch (CoreException coreException) {}
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        this.checkFavorites(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        LaunchHistory launchHistory = this;
        synchronized (launchHistory) {
            ILaunchConfiguration newConfig = DebugPlugin.getDefault().getLaunchManager().getMovedTo(configuration);
            if (newConfig == null) {
                this.fCompleteHistory.remove(configuration);
                this.fFavorites.remove(configuration);
            } else {
                int index = this.fCompleteHistory.indexOf(configuration);
                if (index >= 0) {
                    this.fCompleteHistory.remove(index);
                    this.fCompleteHistory.add(index, newConfig);
                }
                if ((index = this.fFavorites.indexOf(configuration)) >= 0) {
                    this.fFavorites.remove(index);
                    this.fFavorites.add(index, newConfig);
                }
                this.checkFavorites(newConfig);
            }
        }
        this.fireLaunchHistoryChanged();
    }
}

