/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.dialogs.DialogArea;
import org.eclipse.team.internal.ui.dialogs.IResourceMappingResourceFilter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ResourceMappingResourceDisplayArea
extends DialogArea {
    private ResourceMapping mapping;
    private final ResourceMappingContext context = ResourceMappingContext.LOCAL_CONTEXT;
    private TreeViewer viewer;
    private Label label;
    private final IResourceMappingResourceFilter filter;
    private final Map<ResourceMapping, Map<IResource, List<IResource>>> cachedFiltering = new HashMap<ResourceMapping, Map<IResource, List<IResource>>>();
    private String message;

    private static IWorkbenchAdapter getWorkbenchAdapter(IAdaptable o) {
        return (IWorkbenchAdapter)o.getAdapter(IWorkbenchAdapter.class);
    }

    public static String getLabel(ResourceMapping mapping) {
        Object modelObject;
        Object o = mapping;
        IWorkbenchAdapter workbenchAdapter = ResourceMappingResourceDisplayArea.getWorkbenchAdapter((IAdaptable)o);
        if (workbenchAdapter == null && (modelObject = mapping.getModelObject()) instanceof IAdaptable) {
            workbenchAdapter = ResourceMappingResourceDisplayArea.getWorkbenchAdapter((IAdaptable)modelObject);
            o = modelObject;
        }
        if (workbenchAdapter == null) {
            return mapping.toString();
        }
        return workbenchAdapter.getLabel(o);
    }

    public ResourceMappingResourceDisplayArea(ResourceMapping mapping, String string, IResourceMappingResourceFilter filter) {
        this.mapping = mapping;
        this.filter = filter;
        this.message = string;
    }

    @Override
    public void createArea(Composite parent) {
        Composite composite = this.createComposite(parent, 1, true);
        this.label = this.createWrappingLabel(composite, this.message, 1);
        this.viewer = new TreeViewer(composite);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 100;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ResourceComparator(1){

            public int compare(Viewer viewer, Object o1, Object o2) {
                if (o1 instanceof ResourceTraversalElement && o2 instanceof ResourceTraversalElement) {
                    ResourceTraversalElement e1 = (ResourceTraversalElement)o1;
                    ResourceTraversalElement e2 = (ResourceTraversalElement)o2;
                    return super.compare(viewer, (Object)e1.getResource(), (Object)e2.getResource());
                }
                return super.compare(viewer, o1, o2);
            }
        });
        this.setInput(this.message);
        Dialog.applyDialogFont((Control)parent);
    }

    private void setInput(String labelText) {
        if (this.viewer != null) {
            ResourceMappingElement o = null;
            if (this.mapping != null) {
                o = new ResourceMappingElement(this.mapping, this.context);
            }
            this.viewer.setInput(o);
        }
        if (this.label != null) {
            this.message = labelText;
            this.label.setText(labelText);
        }
    }

    public void setMapping(ResourceMapping mapping, String labelText) {
        this.mapping = mapping;
        this.setInput(labelText);
    }

    private boolean isIncludedInFilter(IResource resource, ResourceTraversal traversal) {
        if (this.filter == null) {
            return true;
        }
        Map<IResource, List<IResource>> mappingResources = this.cachedFiltering.get(this.mapping);
        if (mappingResources == null) {
            mappingResources = this.buildFilteredResourceMap(this.mapping, this.context);
            this.cachedFiltering.put(this.mapping, mappingResources);
        }
        return mappingResources.containsKey(resource);
    }

    private Map<IResource, List<IResource>> buildFilteredResourceMap(final ResourceMapping mapping, final ResourceMappingContext context) {
        final HashMap<IResource, List<IResource>> result = new HashMap<IResource, List<IResource>>();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            ResourceTraversal[] traversals;
                            monitor.beginTask(null, -1);
                            ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(context, Policy.subMonitorFor((IProgressMonitor)monitor, (int)-1));
                            int n = traversals.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ResourceTraversal traversal = resourceTraversalArray[n2];
                                this.buildFilteredResourceMap(mapping, traversal, Policy.subMonitorFor((IProgressMonitor)monitor, (int)-1), result);
                                ++n2;
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }

                private void buildFilteredResourceMap(ResourceMapping mapping2, ResourceTraversal traversal, IProgressMonitor monitor, Map<IResource, List<IResource>> result2) throws CoreException {
                    traversal.accept(resource -> {
                        if (ResourceMappingResourceDisplayArea.this.filter.select(resource, mapping2, traversal)) {
                            result2.put(resource, new ArrayList());
                            IResource child = resource;
                            while (!ResourceMappingResourceDisplayArea.isTraversalRoot(traversal, child)) {
                                IContainer parent = child.getParent();
                                ArrayList<IResource> children = (ArrayList<IResource>)result2.get(parent);
                                if (children == null) {
                                    children = new ArrayList<IResource>();
                                    result2.put((IResource)parent, (List<IResource>)children);
                                }
                                children.add(child);
                                child = parent;
                            }
                        }
                        return true;
                    });
                }
            });
        }
        catch (InvocationTargetException e) {
            TeamUIPlugin.log(4, "An error occurred while filtering " + ResourceMappingResourceDisplayArea.getLabel(mapping), e);
        }
        catch (InterruptedException interruptedException) {}
        return result;
    }

    static ResourceTraversal[] getTraversals(ResourceMapping mapping, ResourceMappingContext context) {
        ArrayList traversals = new ArrayList();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                try {
                    traversals.add(mapping.getTraversals(context, monitor));
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
            return (ResourceTraversal[])traversals.get(0);
        }
        catch (InvocationTargetException e) {
            TeamUIPlugin.log(4, "An error occurred while traversing " + ResourceMappingResourceDisplayArea.getLabel(mapping), e);
        }
        catch (InterruptedException interruptedException) {}
        return new ResourceTraversal[0];
    }

    static IResource[] members(IContainer container, RemoteResourceMappingContext context) {
        ArrayList members = new ArrayList();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                try {
                    members.add(context.fetchMembers(container, monitor));
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
            return (IResource[])members.get(0);
        }
        catch (InvocationTargetException e) {
            TeamUIPlugin.log(4, "An error occurred while fetching the members of" + String.valueOf(container.getFullPath()), e);
        }
        catch (InterruptedException interruptedException) {}
        return new IResource[0];
    }

    static boolean isTraversalRoot(ResourceTraversal traversal, IResource resource) {
        IResource[] resources;
        IResource[] iResourceArray = resources = traversal.getResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource root = iResourceArray[n2];
            if (root.equals((Object)resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public class ResourceMappingElement
    implements IWorkbenchAdapter,
    IAdaptable {
        private final ResourceMapping mapping;
        private final ResourceMappingContext context;

        public ResourceMappingElement(ResourceMapping mapping, ResourceMappingContext context) {
            this.mapping = mapping;
            this.context = context;
        }

        public Object[] getChildren(Object o) {
            ResourceTraversal[] traversals = this.getTraversals();
            ArrayList<ResourceTraversalElement> result = new ArrayList<ResourceTraversalElement>();
            ResourceTraversal[] resourceTraversalArray = traversals;
            int n = traversals.length;
            int n2 = 0;
            while (n2 < n) {
                IResource[] resources;
                ResourceTraversal traversal = resourceTraversalArray[n2];
                IResource[] iResourceArray = resources = traversal.getResources();
                int n3 = resources.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource resource = iResourceArray[n4];
                    if (ResourceMappingResourceDisplayArea.this.isIncludedInFilter(resource, traversal)) {
                        result.add(new ResourceTraversalElement(this, traversal, resource, this.context));
                    }
                    ++n4;
                }
                ++n2;
            }
            return result.toArray(new Object[result.size()]);
        }

        private ResourceTraversal[] getTraversals() {
            return ResourceMappingResourceDisplayArea.getTraversals(this.mapping, this.context);
        }

        public ImageDescriptor getImageDescriptor(Object o) {
            Object modelObject;
            o = this.mapping;
            IWorkbenchAdapter workbenchAdapter = ResourceMappingResourceDisplayArea.getWorkbenchAdapter((IAdaptable)o);
            if (workbenchAdapter == null && (modelObject = this.mapping.getModelObject()) instanceof IAdaptable) {
                workbenchAdapter = ResourceMappingResourceDisplayArea.getWorkbenchAdapter((IAdaptable)modelObject);
                o = modelObject;
            }
            if (workbenchAdapter == null) {
                return null;
            }
            return workbenchAdapter.getImageDescriptor(o);
        }

        public String getLabel(Object o) {
            return ResourceMappingResourceDisplayArea.getLabel(this.mapping);
        }

        public Object getParent(Object o) {
            return null;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == IWorkbenchAdapter.class) {
                return (T)this;
            }
            return null;
        }
    }

    public class ResourceTraversalElement
    implements IWorkbenchAdapter,
    IAdaptable {
        private final ResourceTraversal traversal;
        private final ResourceMappingContext context;
        private final IResource resource;
        private final Object parent;

        public ResourceTraversalElement(Object parent, ResourceTraversal traversal, IResource resource, ResourceMappingContext context) {
            this.parent = parent;
            this.traversal = traversal;
            this.resource = resource;
            this.context = context;
        }

        public Object[] getChildren(Object o) {
            if (this.traversal.getDepth() == 2) {
                return this.getChildren(true);
            }
            if (this.traversal.getDepth() == 1 && this.isTraversalRoot(this.resource)) {
                return this.getChildren(false);
            }
            return new Object[0];
        }

        private Object[] getChildren(boolean includeFolders) {
            try {
                if (this.resource.getType() != 1) {
                    IResource[] members = this.members((IContainer)this.resource);
                    ArrayList<ResourceTraversalElement> result = new ArrayList<ResourceTraversalElement>();
                    IResource[] iResourceArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource child = iResourceArray[n2];
                        if ((includeFolders || child.getType() == 1) && ResourceMappingResourceDisplayArea.this.isIncludedInFilter(child, this.traversal)) {
                            result.add(new ResourceTraversalElement(this, this.traversal, child, this.context));
                        }
                        ++n2;
                    }
                    return result.toArray(new Object[result.size()]);
                }
            }
            catch (CoreException e) {
                TeamUIPlugin.log(4, "An error occurred fetching the members of " + String.valueOf(this.resource.getFullPath()), e);
            }
            return new Object[0];
        }

        private IResource[] members(IContainer container) throws CoreException {
            if (this.context instanceof RemoteResourceMappingContext) {
                RemoteResourceMappingContext remoteContext = (RemoteResourceMappingContext)this.context;
                return ResourceMappingResourceDisplayArea.members(container, remoteContext);
            }
            return container.members();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            IWorkbenchAdapter workbenchAdapter = ResourceMappingResourceDisplayArea.getWorkbenchAdapter((IAdaptable)this.resource);
            if (workbenchAdapter == null) {
                return null;
            }
            return workbenchAdapter.getImageDescriptor((Object)this.resource);
        }

        public String getLabel(Object o) {
            if (this.resource.getType() != 4 && this.isTraversalRoot(this.resource)) {
                return this.resource.getFullPath().toString();
            }
            IWorkbenchAdapter workbenchAdapter = ResourceMappingResourceDisplayArea.getWorkbenchAdapter((IAdaptable)this.resource);
            if (workbenchAdapter == null) {
                return this.resource.getName();
            }
            return workbenchAdapter.getLabel((Object)this.resource);
        }

        private boolean isTraversalRoot(IResource resource) {
            return ResourceMappingResourceDisplayArea.isTraversalRoot(this.traversal, resource);
        }

        public Object getParent(Object o) {
            return this.parent;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == IWorkbenchAdapter.class) {
                return (T)this;
            }
            return null;
        }

        public IResource getResource() {
            return this.resource;
        }
    }
}

