/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.internal.CompareContainer;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DiffImageDescriptor;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class CompareConfiguration {
    public static final String IGNORE_WHITESPACE = "IGNORE_WHITESPACE";
    public static final String SHOW_PSEUDO_CONFLICTS = "SHOW_PSEUDO_CONFLICTS";
    public static final String USE_OUTLINE_VIEW = "USE_OUTLINE_VIEW";
    public static final String MIRRORED = "MIRRORED";
    private static ImageDescriptor[] fgImages = new ImageDescriptor[32];
    private final IPreferenceStore fPreferenceStore;
    private final ListenerList<IPropertyChangeListener> fListeners = new ListenerList();
    private final HashMap<String, Object> fProperties = new HashMap();
    private boolean fLeftEditable = true;
    private boolean fRightEditable = true;
    private String fAncestorLabel;
    private String fLeftLabel;
    private String fRightLabel;
    private Image fAncestorImage;
    private Image fRightImage;
    private Image fLeftImage;
    private ICompareContainer fContainer;
    private final DefaultLabelProvider labelProvider = new DefaultLabelProvider();
    private boolean fDisposed;
    private LocalResourceManager fResourceManager;
    private final Set<Integer> fIgnoredChanges = new HashSet<Integer>(6);

    static {
        CompareConfiguration.fgImages[1] = CompareUIPlugin.getImageDescriptor("ovr16/add_ov.png");
        CompareConfiguration.fgImages[5] = CompareUIPlugin.getImageDescriptor("ovr16/r_inadd_ov.png");
        CompareConfiguration.fgImages[9] = CompareUIPlugin.getImageDescriptor("ovr16/r_outadd_ov.png");
        CompareConfiguration.fgImages[2] = CompareUIPlugin.getImageDescriptor("ovr16/del_ov.png");
        CompareConfiguration.fgImages[6] = CompareUIPlugin.getImageDescriptor("ovr16/r_indel_ov.png");
        CompareConfiguration.fgImages[10] = CompareUIPlugin.getImageDescriptor("ovr16/r_outdel_ov.png");
        CompareConfiguration.fgImages[7] = CompareUIPlugin.getImageDescriptor("ovr16/r_inchg_ov.png");
        CompareConfiguration.fgImages[11] = CompareUIPlugin.getImageDescriptor("ovr16/r_outchg_ov.png");
        CompareConfiguration.fgImages[13] = CompareUIPlugin.getImageDescriptor("ovr16/confadd_ov.png");
        CompareConfiguration.fgImages[14] = CompareUIPlugin.getImageDescriptor("ovr16/confdel_ov.png");
        CompareConfiguration.fgImages[15] = CompareUIPlugin.getImageDescriptor("ovr16/confchg_ov.png");
        CompareConfiguration.fgImages[17] = CompareUIPlugin.getImageDescriptor("ovr16/add_ov.png");
        CompareConfiguration.fgImages[21] = CompareUIPlugin.getImageDescriptor("ovr16/inadd_ov.png");
        CompareConfiguration.fgImages[25] = CompareUIPlugin.getImageDescriptor("ovr16/outadd_ov.png");
        CompareConfiguration.fgImages[18] = CompareUIPlugin.getImageDescriptor("ovr16/del_ov.png");
        CompareConfiguration.fgImages[22] = CompareUIPlugin.getImageDescriptor("ovr16/indel_ov.png");
        CompareConfiguration.fgImages[26] = CompareUIPlugin.getImageDescriptor("ovr16/outdel_ov.png");
        CompareConfiguration.fgImages[23] = CompareUIPlugin.getImageDescriptor("ovr16/inchg_ov.png");
        CompareConfiguration.fgImages[27] = CompareUIPlugin.getImageDescriptor("ovr16/outchg_ov.png");
        CompareConfiguration.fgImages[29] = CompareUIPlugin.getImageDescriptor("ovr16/confadd_ov.png");
        CompareConfiguration.fgImages[30] = CompareUIPlugin.getImageDescriptor("ovr16/confdel_ov.png");
        CompareConfiguration.fgImages[31] = CompareUIPlugin.getImageDescriptor("ovr16/confchg_ov.png");
    }

    public CompareConfiguration(IPreferenceStore prefStore) {
        this.fPreferenceStore = prefStore;
        if (this.fPreferenceStore != null) {
            boolean b = this.fPreferenceStore.getBoolean("org.eclipse.compare.InitiallyShowAncestorPane");
            this.setProperty(ICompareUIConstants.PROP_ANCESTOR_VISIBLE, b);
            b = this.fPreferenceStore.getBoolean("org.eclipse.compare.IgnoreWhitespace");
            this.setProperty(IGNORE_WHITESPACE, b);
            b = this.fPreferenceStore.getBoolean("org.eclipse.compare.Swapped");
            this.setProperty(MIRRORED, b);
        }
    }

    public CompareConfiguration() {
        this(CompareUIPlugin.getDefault().getPreferenceStore());
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    public Image getImage(int kind) {
        if (this.fDisposed) {
            return null;
        }
        ImageDescriptor id = this.getImageDescriptor(kind);
        if (id == null) {
            return null;
        }
        ResourceManager rm = this.getResourceManager();
        return (Image)rm.create((DeviceResourceDescriptor)id);
    }

    private synchronized ResourceManager getResourceManager() {
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    public Image getImage(Image base, int kind) {
        if (this.fDisposed) {
            return null;
        }
        DiffImageDescriptor id = new DiffImageDescriptor(base, this.getImageDescriptor(kind), 22, false);
        ResourceManager rm = this.getResourceManager();
        return (Image)rm.create((DeviceResourceDescriptor)id);
    }

    public boolean isMirrored() {
        Object property = this.getProperty(MIRRORED);
        return property instanceof Boolean && (Boolean)property != false;
    }

    private ImageDescriptor getImageDescriptor(int kind) {
        return fgImages[(kind & 0xF) + (this.isMirrored() ? 16 : 0)];
    }

    public void dispose() {
        this.fDisposed = true;
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
        }
        this.labelProvider.dispose();
    }

    private void fireChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = null;
        Object[] listeners = this.fListeners.getListeners();
        if (listeners != null) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                IPropertyChangeListener l = (IPropertyChangeListener)listener;
                if (event == null) {
                    event = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
                }
                l.propertyChange(event);
                ++n2;
            }
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void setProperty(String key, Object newValue) {
        Object oldValue = this.fProperties.get(key);
        this.fProperties.put(key, newValue);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.fireChange(key, oldValue, newValue);
        }
    }

    public Object getProperty(String key) {
        return this.fProperties.get(key);
    }

    public void setAncestorLabel(String label) {
        this.fAncestorLabel = label;
    }

    public String getAncestorLabel(Object element) {
        return this.labelProvider.getAncestorLabel(element);
    }

    public void setAncestorImage(Image image) {
        this.fAncestorImage = image;
    }

    public Image getAncestorImage(Object element) {
        return this.labelProvider.getAncestorImage(element);
    }

    public void setLeftEditable(boolean editable) {
        this.fLeftEditable = editable;
    }

    public boolean isLeftEditable() {
        return this.fLeftEditable;
    }

    public void setLeftLabel(String label) {
        this.fLeftLabel = label;
    }

    public String getLeftLabel(Object element) {
        return this.labelProvider.getLeftLabel(element);
    }

    public void setLeftImage(Image image) {
        this.fLeftImage = image;
    }

    public Image getLeftImage(Object element) {
        return this.labelProvider.getLeftImage(element);
    }

    public void setRightEditable(boolean editable) {
        this.fRightEditable = editable;
    }

    public boolean isRightEditable() {
        return this.fRightEditable;
    }

    public void setRightLabel(String label) {
        this.fRightLabel = label;
    }

    public String getRightLabel(Object element) {
        return this.labelProvider.getRightLabel(element);
    }

    public void setRightImage(Image image) {
        this.fRightImage = image;
    }

    public Image getRightImage(Object element) {
        return this.labelProvider.getRightImage(element);
    }

    public ICompareContainer getContainer() {
        if (this.fContainer == null) {
            this.fContainer = new CompareContainer();
        }
        return this.fContainer;
    }

    public void setContainer(ICompareContainer container) {
        this.fContainer = container;
    }

    public ICompareInputLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ICompareInput input, ICompareInputLabelProvider labelProvider) {
        this.labelProvider.setLabelProvider(input, labelProvider);
    }

    public void setDefaultLabelProvider(ICompareInputLabelProvider labelProvider) {
        this.labelProvider.setDefaultLabelProvider(labelProvider);
    }

    public void setChangeIgnored(int kind, boolean ignored) {
        if (ignored) {
            this.fIgnoredChanges.add(kind);
        } else {
            this.fIgnoredChanges.remove(kind);
        }
    }

    public boolean isChangeIgnored(int kind) {
        return this.fIgnoredChanges.contains(kind);
    }

    private class DefaultLabelProvider
    extends LabelProvider
    implements ICompareInputLabelProvider,
    ILabelProviderListener {
        private final Map<ICompareInput, ICompareInputLabelProvider> labelProviders = new HashMap<ICompareInput, ICompareInputLabelProvider>();
        private ICompareInputLabelProvider defaultLabelProvider;

        private DefaultLabelProvider() {
        }

        @Override
        public Image getAncestorImage(Object input) {
            Image image;
            ICompareInputLabelProvider provider = this.getLabelProvider(input);
            if (provider != null && (image = provider.getAncestorImage(input)) != null) {
                return image;
            }
            return CompareConfiguration.this.fAncestorImage;
        }

        @Override
        public String getAncestorLabel(Object input) {
            String label;
            ICompareInputLabelProvider provider = this.getLabelProvider(input);
            if (provider != null && (label = provider.getAncestorLabel(input)) != null) {
                return label;
            }
            return CompareConfiguration.this.fAncestorLabel;
        }

        @Override
        public Image getLeftImage(Object input) {
            Image image;
            ICompareInputLabelProvider provider = this.getLabelProvider(input);
            if (provider != null && (image = provider.getLeftImage(input)) != null) {
                return image;
            }
            return CompareConfiguration.this.fLeftImage;
        }

        @Override
        public String getLeftLabel(Object input) {
            String label;
            ICompareInputLabelProvider provider = this.getLabelProvider(input);
            if (provider != null && (label = provider.getLeftLabel(input)) != null) {
                return label;
            }
            return CompareConfiguration.this.fLeftLabel;
        }

        @Override
        public Image getRightImage(Object input) {
            Image image;
            ICompareInputLabelProvider provider = this.getLabelProvider(input);
            if (provider != null && (image = provider.getRightImage(input)) != null) {
                return image;
            }
            return CompareConfiguration.this.fRightImage;
        }

        @Override
        public String getRightLabel(Object input) {
            String label;
            ICompareInputLabelProvider provider = this.getLabelProvider(input);
            if (provider != null && (label = provider.getRightLabel(input)) != null) {
                return label;
            }
            return CompareConfiguration.this.fRightLabel;
        }

        public ICompareInputLabelProvider getLabelProvider(Object input) {
            ICompareInputLabelProvider lp = this.labelProviders.get(input);
            if (lp == null) {
                return this.defaultLabelProvider;
            }
            return lp;
        }

        public void setLabelProvider(ICompareInput input, ICompareInputLabelProvider labelProvider) {
            ICompareInputLabelProvider old = this.labelProviders.get(input);
            if (old != null) {
                old.removeListener(this);
            }
            this.labelProviders.put(input, labelProvider);
            labelProvider.addListener(this);
        }

        public Image getImage(Object element) {
            ICompareInput ci;
            Image image;
            Image image2;
            ICompareInputLabelProvider provider = this.getLabelProvider(element);
            if (provider != null && (image2 = provider.getImage(element)) != null) {
                return image2;
            }
            if (element instanceof ICompareInput && (image = (ci = (ICompareInput)element).getImage()) != null) {
                return image;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            ICompareInput ci;
            String label;
            String label2;
            ICompareInputLabelProvider provider = this.getLabelProvider(element);
            if (provider != null && (label2 = provider.getText(element)) != null) {
                return label2;
            }
            if (element instanceof ICompareInput && (label = (ci = (ICompareInput)element).getName()) != null) {
                return label;
            }
            return super.getText(element);
        }

        public void dispose() {
            for (ICompareInputLabelProvider lp : this.labelProviders.values()) {
                lp.removeListener(this);
            }
            if (this.defaultLabelProvider != null) {
                this.defaultLabelProvider.removeListener(this);
            }
            this.defaultLabelProvider = null;
            this.labelProviders.clear();
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, event.getElements()));
        }

        public void setDefaultLabelProvider(ICompareInputLabelProvider labelProvider) {
            if (this.defaultLabelProvider != null) {
                this.defaultLabelProvider.removeListener(this);
            }
            this.defaultLabelProvider = labelProvider;
            if (this.defaultLabelProvider != null) {
                this.defaultLabelProvider.addListener(this);
            }
        }
    }
}

