/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.identity.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mylyn.commons.identity.core.Account;
import org.eclipse.mylyn.commons.identity.core.IIdentity;
import org.eclipse.mylyn.commons.identity.core.IProfile;
import org.eclipse.mylyn.commons.identity.core.IProfileImage;
import org.eclipse.mylyn.internal.commons.identity.ui.PeopleCategory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.internal.WorkbenchImages;

public class PersonLabelProvider
extends LabelProvider {
    private static final int IMAGE_SIZE = 16;
    ImageRegistry registry = new ImageRegistry();

    public void dispose() {
        this.registry.dispose();
        super.dispose();
    }

    public Image getImage(Object object) {
        if (object instanceof PeopleCategory) {
            return WorkbenchImages.getImage((String)"IMG_OBJ_FOLDER");
        }
        if (object instanceof IIdentity) {
            Future result;
            IIdentity identity = (IIdentity)object;
            Image image = this.registry.get(identity.getId().toString());
            if (image == null && (result = identity.requestImage(16, 16)).isDone()) {
                try {
                    IProfileImage profileImage = (IProfileImage)result.get(0L, TimeUnit.SECONDS);
                    if (profileImage != null) {
                        ImageData data = new ImageData((InputStream)new ByteArrayInputStream(profileImage.getData()));
                        if (data.width != 16 || data.height != 16) {
                            data = data.scaledTo(16, 16);
                        }
                        this.registry.put(identity.getId().toString(), ImageDescriptor.createFromImageData((ImageData)data));
                        image = this.registry.get(identity.getId().toString());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return image;
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof IIdentity) {
            IIdentity identity = (IIdentity)object;
            Future result = identity.requestProfile();
            if (result.isDone()) {
                try {
                    IProfile profile = (IProfile)result.get(0L, TimeUnit.SECONDS);
                    if (profile.getName() != null) {
                        return profile.getName();
                    }
                    if (profile.getEmail() != null) {
                        return profile.getEmail();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return identity.getId().toString();
        }
        if (object instanceof Account) {
            Account account = (Account)object;
            if (account.getName() != null) {
                return account.getName() + " <" + account.getId() + ">";
            }
            return account.getId();
        }
        return null;
    }
}

