/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.undo.snapshot;

import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.resources.undo.snapshot.AbstractResourceSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.FileSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.FolderSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.ProjectSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.ResourceSnapshotMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.undo.snapshot.IContainerSnapshot;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.resources.undo.snapshot.ResourceSnapshotFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class ContainerSnapshot<T extends IContainer>
extends AbstractResourceSnapshot<T>
implements IContainerSnapshot<T> {
    String name;
    URI location;
    IResourceFilterDescription[] filters;
    String defaultCharSet;
    final List<IResourceSnapshot<? extends IResource>> members = new ArrayList<IResourceSnapshot<? extends IResource>>();

    public static <R extends IContainer> ContainerSnapshot<? extends R> fromContainer(R container) {
        return ContainerSnapshot.fromContainer(container, false);
    }

    public static <R extends IContainer> ContainerSnapshot<? extends R> fromVirtualFolderContainer(R container) {
        return ContainerSnapshot.fromContainer(container, true);
    }

    public static <R extends IContainer> ContainerSnapshot<? extends R> fromContainer(R container, boolean usingVirtualFolder) {
        IPath fullPath = container.getFullPath();
        ContainerSnapshot firstCreatedParent = null;
        ContainerSnapshot currentContainerDescription = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer currentContainer = (IContainer)root.findMember(fullPath);
        if (currentContainer != null) {
            return (ContainerSnapshot)ResourceSnapshotFactory.fromResource(container);
        }
        currentContainer = root;
        int i = 0;
        while (i < fullPath.segmentCount()) {
            String currentSegment = fullPath.segment(i);
            IResource resource = currentContainer.findMember(currentSegment);
            if (resource != null) {
                currentContainer = (IContainer)resource;
            } else if (i == 0) {
                currentContainerDescription = firstCreatedParent = new ProjectSnapshot(root.getProject(currentSegment));
            } else {
                IFolder folderHandle = currentContainer.getFolder(IPath.fromOSString((String)currentSegment));
                FolderSnapshot currentFolder = new FolderSnapshot(folderHandle, usingVirtualFolder);
                currentContainer = folderHandle;
                if (currentContainerDescription != null) {
                    currentContainerDescription.addMember(currentFolder);
                }
                currentContainerDescription = currentFolder;
                if (firstCreatedParent == null) {
                    firstCreatedParent = currentFolder;
                }
            }
            ++i;
        }
        return firstCreatedParent;
    }

    public ContainerSnapshot() {
    }

    public ContainerSnapshot(T container) {
        super(container);
        this.name = container.getName();
        if (container.isLinked()) {
            this.location = container.getLocationURI();
        }
        try {
            if (container.isAccessible()) {
                IResource[] resourceMembers;
                this.defaultCharSet = container.getDefaultCharset(false);
                IResource[] iResourceArray = resourceMembers = container.members();
                int n = resourceMembers.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resourceMember = iResourceArray[n2];
                    this.members.add(ResourceSnapshotFactory.fromResource(resourceMember));
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected final void createChildResources(IContainer parentHandle, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.members.size());
        for (IResourceSnapshot<? extends IResource> member : this.members) {
            if (member instanceof AbstractResourceSnapshot) {
                ((AbstractResourceSnapshot)member).parent = parentHandle;
            }
            member.createResource((IProgressMonitor)subMonitor.split(1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void recordStateFromHistory(IProgressMonitor mon) throws CoreException {
        if (this.members != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (String)ResourceSnapshotMessages.FolderDescription_SavingUndoInfoProgress, (int)this.members.size());
            for (IResourceSnapshot<? extends IResource> member : this.members) {
                void folderSnapshot;
                SubMonitor iterationMonitor = subMonitor.split(1);
                IResourceSnapshot<? extends IResource> iResourceSnapshot = member;
                if (iResourceSnapshot instanceof FileSnapshot) {
                    void fileSnapshot;
                    FileSnapshot cfr_ignored_0 = (FileSnapshot)iResourceSnapshot;
                    FileSnapshot cfr_ignored_1 = (FileSnapshot)iResourceSnapshot;
                    fileSnapshot.recordStateFromHistory((IProgressMonitor)iterationMonitor);
                    continue;
                }
                IResourceSnapshot<? extends IResource> iResourceSnapshot2 = member;
                if (!(iResourceSnapshot2 instanceof FolderSnapshot)) continue;
                FolderSnapshot cfr_ignored_2 = (FolderSnapshot)iResourceSnapshot2;
                FolderSnapshot cfr_ignored_3 = (FolderSnapshot)iResourceSnapshot2;
                folderSnapshot.recordStateFromHistory((IProgressMonitor)iterationMonitor);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IResourceSnapshot<? extends IResource>[] getMembers() {
        return this.members.toArray((IResourceSnapshot[])Array.newInstance(IResourceSnapshot.class, this.members.size()));
    }

    @Override
    public void addMember(IResourceSnapshot<? extends IResource> member) {
        this.members.add(member);
    }

    @Override
    protected void restoreResourceAttributes(IResource resource) throws CoreException {
        super.restoreResourceAttributes(resource);
        Assert.isLegal((boolean)(resource instanceof IContainer));
        IContainer container = (IContainer)resource;
        if (this.defaultCharSet != null) {
            container.setDefaultCharset(this.defaultCharSet, null);
        }
    }

    @Override
    public void setLocation(URI location) {
        this.location = location;
    }

    @Override
    public void setFilters(IResourceFilterDescription[] filters) {
        this.filters = filters;
    }

    @Override
    public boolean verifyExistence(boolean checkMembers) {
        boolean existence = super.verifyExistence(checkMembers);
        if (existence) {
            if (checkMembers) {
                for (IResourceSnapshot<? extends IResource> member : this.members) {
                    if (member.verifyExistence(checkMembers)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

