/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.logback.configuration;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.function.BooleanSupplier;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class M2ELogbackConfigurator
extends BasicConfigurator
implements Configurator {
    private static final ILog LOG = Platform.getLog(M2ELogbackConfigurator.class);
    private static final String RESOURCES_PLUGIN_ID = "org.eclipse.core.resources";
    private static final String PROPERTY_LOG_DIRECTORY = "org.eclipse.m2e.log.dir";

    public Configurator.ExecutionStatus configure(LoggerContext lc) {
        if (!M2ELogbackConfigurator.isStateLocationInitialized()) {
            super.configure(lc);
            LOG.info("Activated before the state location was initialized. Retry after the state location is initialized.");
            M2ELogbackConfigurator.runConditionally(() -> this.configureLogback(lc), M2ELogbackConfigurator::isStateLocationInitialized, "logback configurator timer");
        } else {
            this.configureLogback(lc);
        }
        return Configurator.ExecutionStatus.NEUTRAL;
    }

    private synchronized void configureLogback(LoggerContext lc) {
        block24: {
            try {
                Throwable throwable;
                Bundle bundle = Platform.getBundle((String)"org.eclipse.m2e.logback");
                Path stateDir = Platform.getStateLocation((Bundle)bundle).toFile().toPath();
                Path configFile = stateDir.resolve("logback." + bundle.getVersion() + ".xml");
                LOG.info("Logback config file: " + configFile.toAbsolutePath());
                if (!Files.isRegularFile(configFile, new LinkOption[0])) {
                    Throwable throwable2 = null;
                    throwable = null;
                    try (InputStream is = bundle.getEntry("defaultLogbackConfiguration/logback.xml").openStream();){
                        Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
                        Files.copy(is, configFile, new CopyOption[0]);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                if (System.getProperty(PROPERTY_LOG_DIRECTORY, "").length() <= 0) {
                    System.setProperty(PROPERTY_LOG_DIRECTORY, stateDir.toAbsolutePath().toString());
                }
                M2ELogbackConfigurator.loadConfiguration(lc, configFile.toUri().toURL());
                Path legacyLogbackState = stateDir.resolveSibling("org.eclipse.m2e.logback.configuration");
                if (!Files.isDirectory(legacyLogbackState, new LinkOption[0])) break block24;
                throwable = null;
                Object var7_11 = null;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(legacyLogbackState);){
                    for (Path path : stream) {
                        if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                        Files.delete(path);
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
                Files.delete(legacyLogbackState);
            }
            catch (Exception e) {
                LOG.log((IStatus)Status.warning((String)("Exception while setting up logging:" + e.getMessage()), (Throwable)e));
            }
        }
    }

    private static void loadConfiguration(LoggerContext lc, URL configFile) throws JoranException {
        lc.reset();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        configurator.doConfigure(configFile);
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
        M2ELogbackConfigurator.logJavaProperties(LoggerFactory.getLogger(M2ELogbackConfigurator.class));
    }

    private static boolean isStateLocationInitialized() {
        if (!Platform.isRunning()) {
            return false;
        }
        Bundle resourcesBundle = Platform.getBundle((String)RESOURCES_PLUGIN_ID);
        return resourcesBundle != null && resourcesBundle.getState() == 32;
    }

    private static void runConditionally(final Runnable action, final BooleanSupplier condition, String name) {
        final Timer timer = new Timer(name);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (condition.getAsBoolean()) {
                    timer.cancel();
                    action.run();
                }
            }
        }, 0L, 50L);
    }

    private static void logJavaProperties(Logger log) {
        Properties javaProperties = System.getProperties();
        TreeMap<String, String> sortedProperties = new TreeMap<String, String>();
        for (String key : javaProperties.stringPropertyNames()) {
            sortedProperties.put(key, javaProperties.getProperty(key));
        }
        log.debug("Java properties (ordered by property name):");
        sortedProperties.forEach((k, v) -> log.debug("   {}={}", k, v));
    }
}

