/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.dynamic.DocumentReader;
import org.eclipse.help.internal.dynamic.ExtensionHandler;
import org.eclipse.help.internal.dynamic.FilterHandler;
import org.eclipse.help.internal.dynamic.IncludeHandler;
import org.eclipse.help.internal.dynamic.ProcessorHandler;
import org.eclipse.help.internal.dynamic.XMLProcessor;
import org.eclipse.help.internal.search.HTMLDocParser;
import org.eclipse.help.internal.xhtml.XHTMLCharsetHandler;
import org.eclipse.help.internal.xhtml.XHTMLContentDescriber;
import org.xml.sax.SAXException;

public class DynamicXHTMLProcessor {
    private static IContentDescriber xhtmlDescriber;
    private static XMLProcessor xmlProcessor;
    private static String xmlProcessorLocale;
    private static XMLProcessor xmlProcessorNoFilter;
    private static String xmlProcessorNoFilterLocale;

    public static InputStream process(String href, InputStream in, String locale, boolean filter) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        BufferedInputStream buf = new BufferedInputStream(in, 4096);
        int bufferSize = Math.max(4096, 2048);
        byte[] buffer = new byte[bufferSize];
        buf.mark(Math.max(4096, 2048));
        buf.read(buffer);
        buf.reset();
        boolean isXHTML = DynamicXHTMLProcessor.isXHTML(new ByteArrayInputStream(buffer));
        if (isXHTML) {
            String charset = HTMLDocParser.getCharsetFromHTML(new ByteArrayInputStream(buffer));
            if (filter) {
                return DynamicXHTMLProcessor.getXmlProcessor(locale).process((InputStream)buf, href, charset);
            }
            return DynamicXHTMLProcessor.getXmlProcessorNoFilter(locale).process((InputStream)buf, href, charset);
        }
        return buf;
    }

    private static synchronized XMLProcessor getXmlProcessorNoFilter(String locale) {
        if (!Objects.equals(xmlProcessorNoFilterLocale, locale)) {
            xmlProcessorNoFilterLocale = locale;
            xmlProcessorNoFilter = null;
        }
        if (xmlProcessorNoFilter == null) {
            DocumentReader reader = new DocumentReader();
            xmlProcessorNoFilter = new XMLProcessor(new ProcessorHandler[]{new IncludeHandler(reader, locale), new ExtensionHandler(reader, locale), new XHTMLCharsetHandler()});
        }
        return xmlProcessorNoFilter;
    }

    private static synchronized XMLProcessor getXmlProcessor(String locale) {
        if (!Objects.equals(xmlProcessorLocale, locale)) {
            xmlProcessorLocale = locale;
            xmlProcessor = null;
        }
        if (xmlProcessor == null) {
            DocumentReader reader = new DocumentReader();
            xmlProcessor = new XMLProcessor(new ProcessorHandler[]{new IncludeHandler(reader, locale), new ExtensionHandler(reader, locale), new XHTMLCharsetHandler(), new FilterHandler((IEvaluationContext)HelpEvaluationContext.getContext())});
        }
        return xmlProcessor;
    }

    private static synchronized boolean isXHTML(InputStream in) {
        if (xhtmlDescriber == null) {
            xhtmlDescriber = new XHTMLContentDescriber();
        }
        if (in != null) {
            try {
                return xhtmlDescriber.describe(in, null) == 2;
            }
            catch (IOException iOException) {}
        }
        return false;
    }
}

