/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.mpc.ui;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.model.Node;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.commands.ImportFavoritesWizardCommand;
import org.eclipse.epp.internal.mpc.ui.commands.MarketplaceWizardCommand;
import org.eclipse.epp.internal.mpc.ui.urlhandling.FavoritesUrlHandler;
import org.eclipse.epp.internal.mpc.ui.urlhandling.MarketplaceUrlUtil;
import org.eclipse.epp.internal.mpc.ui.urlhandling.SolutionUrlHandler;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.Messages;
import org.eclipse.epp.mpc.ui.Operation;
import org.eclipse.osgi.util.NLS;

public abstract class MarketplaceUrlHandler {
    public static final String DESCRIPTOR_HINT = "org.eclipse.epp.mpc.descriptorHint";
    public static final String MPC_INSTALL_URI = "/mpc/install?";
    public static final String SITE_SEARCH_URI = "/search/site";
    private static final Pattern CONTENT_URL_PATTERN = Pattern.compile("(?:^|/)content/([^/#?]+)");
    private static final Pattern NODE_URL_PATTERN = Pattern.compile("(?:^|/)node/([^/#?]+)");
    public static final String UTF_8 = "UTF-8";

    public static SolutionInstallationInfo createSolutionInstallInfo(String url) {
        return SolutionUrlHandler.DEFAULT.selectUrlHandler(url).map(handler -> handler.parse(url)).orElse(null);
    }

    public static String getMPCState(String url) {
        return SolutionUrlHandler.DEFAULT.selectUrlHandler(url).map(handler -> handler.getMPCState(url)).orElse(null);
    }

    public static boolean isPotentialSolution(String url) {
        return SolutionUrlHandler.DEFAULT.selectUrlHandler(url).map(handler -> handler.isPotentialSolution(url)).orElse(false);
    }

    public static boolean isPotentialFavoritesList(String url) {
        return FavoritesUrlHandler.DEFAULT.selectUrlHandler(url).map(handler -> handler.isPotentialFavoritesList(url)).orElse(false);
    }

    public static boolean triggerInstall(SolutionInstallationInfo info) {
        if (info.getRequestUrl() != null) {
            MarketplaceClientUi.getLog().log((IStatus)new Status(1, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.MarketplaceUrlHandler_performInstallRequest, (Object)info.getRequestUrl())));
        }
        String installId = info.getInstallId();
        String mpcState = info.getState();
        CatalogDescriptor catalogDescriptor = info.getCatalogDescriptor();
        MarketplaceWizardCommand command = new MarketplaceWizardCommand();
        command.setSelectedCatalogDescriptor(catalogDescriptor);
        try {
            if (mpcState != null) {
                command.setWizardState(URLDecoder.decode(mpcState, UTF_8));
            }
            HashMap<String, Operation> nodeToOperation = new HashMap<String, Operation>();
            nodeToOperation.put(URLDecoder.decode(installId, UTF_8), Operation.INSTALL);
            command.setOperations(nodeToOperation);
        }
        catch (UnsupportedEncodingException e1) {
            throw new IllegalStateException(e1);
        }
        try {
            command.execute(new ExecutionEvent());
            return true;
        }
        catch (ExecutionException e) {
            IStatus status = MarketplaceClientCore.computeStatus((Throwable)e, (String)Messages.MarketplaceUrlHandler_cannotOpenMarketplaceWizard);
            MarketplaceClientUi.handle(status, 7);
            return false;
        }
    }

    public static boolean triggerFavorites(String favoritesUrl) {
        return FavoritesUrlHandler.DEFAULT.selectUrlHandler(favoritesUrl).map(handler -> handler.parse(favoritesUrl)).map(command -> MarketplaceUrlHandler.triggerFavoritesImport(command)).orElse(Boolean.FALSE);
    }

    protected static boolean triggerFavoritesImport(FavoritesDescriptor descriptor) {
        try {
            ImportFavoritesWizardCommand command = new ImportFavoritesWizardCommand();
            command.setSelectedCatalogDescriptor(descriptor.getCatalogDescriptor());
            command.setFavoritesUrl(descriptor.getFavoritesUrl());
            command.execute(new ExecutionEvent());
            return true;
        }
        catch (ExecutionException e) {
            IStatus status = MarketplaceClientCore.computeStatus((Throwable)e, (String)Messages.MarketplaceUrlHandler_cannotOpenMarketplaceWizard);
            MarketplaceClientUi.handle(status, 7);
            return false;
        }
    }

    public boolean handleUri(String uri) {
        Object baseUri;
        Object descriptor;
        SolutionInstallationInfo installInfo;
        if (MarketplaceUrlHandler.isPotentialSolution(uri) && (installInfo = MarketplaceUrlHandler.createSolutionInstallInfo(uri)) != null) {
            return this.handleInstallRequest(installInfo, uri);
        }
        if (MarketplaceUrlHandler.isPotentialFavoritesList(uri) && ((Optional)(descriptor = FavoritesUrlHandler.DEFAULT.selectUrlHandler(uri).map(handler -> handler.parse(uri)))).isPresent()) {
            return this.handleImportFavoritesRequest((FavoritesDescriptor)((Optional)descriptor).get());
        }
        if (!uri.startsWith("http:") && !uri.startsWith("https:")) {
            return false;
        }
        descriptor = MarketplaceUrlUtil.findCatalogDescriptor(uri, false);
        if (descriptor == null && (descriptor = this.handleUnknownCatalog(uri)) == null) {
            return false;
        }
        try {
            baseUri = ((CatalogDescriptor)descriptor).getUrl().toURI().toString();
            if (!((String)baseUri).endsWith("/")) {
                baseUri = (String)baseUri + "/";
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        String resolvedUri = uri;
        if (!uri.startsWith((String)baseUri) && !(resolvedUri = this.resolve(uri, (String)baseUri, (CatalogDescriptor)descriptor)).startsWith((String)baseUri)) {
            return false;
        }
        String relativeUri = resolvedUri.substring(((String)baseUri).length());
        if (relativeUri.startsWith("favorites/top")) {
            return this.handleTopFavorites((CatalogDescriptor)descriptor, relativeUri);
        }
        if (relativeUri.startsWith("featured")) {
            return this.handleFeatured((CatalogDescriptor)descriptor, relativeUri);
        }
        if (relativeUri.startsWith("content")) {
            return this.handleNodeContent((CatalogDescriptor)descriptor, relativeUri);
        }
        if (relativeUri.startsWith("node")) {
            return this.handleNode((CatalogDescriptor)descriptor, relativeUri);
        }
        if (relativeUri.startsWith("popular/top")) {
            return this.handlePopular((CatalogDescriptor)descriptor, relativeUri);
        }
        if (relativeUri.startsWith("recent")) {
            return this.handleRecent((CatalogDescriptor)descriptor, relativeUri);
        }
        if (relativeUri.startsWith("search/apachesolr_search/") || relativeUri.startsWith("api/p/search/apachesolr_search/")) {
            return this.handleSolrSearch((CatalogDescriptor)descriptor, relativeUri);
        }
        if (relativeUri.startsWith(SITE_SEARCH_URI.substring(1))) {
            return this.handleSiteSearch((CatalogDescriptor)descriptor, relativeUri);
        }
        return this.handleUnknownPath((CatalogDescriptor)descriptor, relativeUri);
    }

    protected String resolve(String url, String baseUri, CatalogDescriptor descriptor) {
        if (((String)url).startsWith("https:") && baseUri.startsWith("http:")) {
            url = "http:" + ((String)url).substring("https:".length());
        } else if (((String)url).startsWith("http:") && baseUri.startsWith("https:")) {
            url = "https:" + ((String)url).substring("http:".length());
        }
        return url;
    }

    protected boolean handleUnknownPath(CatalogDescriptor descriptor, String url) {
        return false;
    }

    private boolean handleSolrSearch(CatalogDescriptor descriptor, String url) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String searchString = this.parseSearchQuery(descriptor, url, params);
            return this.handleSearch(descriptor, url, searchString, params);
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private boolean handleSiteSearch(CatalogDescriptor descriptor, String url) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            String searchString = this.parseSearchQuery(descriptor, url, params);
            StringBuilder filter = new StringBuilder();
            Iterator i = params.values().iterator();
            while (i.hasNext()) {
                int sep;
                String str = (String)i.next();
                if (!str.startsWith("im_taxonomy_vocabulary_") || (sep = str.indexOf(58)) == -1) continue;
                String tid = str.substring(sep + 1);
                if (filter.length() > 0) {
                    filter.append(' ');
                }
                filter.append(tid);
                i.remove();
            }
            return this.handleSearch(descriptor, url, searchString, params);
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private String parseSearchQuery(CatalogDescriptor descriptor, String url, Map<String, String> params) throws URISyntaxException, MalformedURLException {
        URI searchUri = new URL(descriptor.getUrl(), url).toURI();
        String path = searchUri.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int sep = path.lastIndexOf(47);
        String searchString = path.substring(sep + 1);
        String query = searchUri.getQuery();
        if (query != null) {
            this.extractParams(query, params);
        }
        return searchString;
    }

    protected boolean handleSearch(CatalogDescriptor descriptor, String url, String searchString, Map<String, String> params) {
        return false;
    }

    private void extractParams(String query, Map<String, String> params) {
        String[] paramStrings;
        String[] stringArray = paramStrings = query.split("&");
        int n = paramStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] parts = param.split("=");
            if (parts.length == 2) {
                params.put(parts[0], parts[1]);
            }
            ++n2;
        }
    }

    protected boolean handleRecent(CatalogDescriptor descriptor, String url) {
        return false;
    }

    protected boolean handlePopular(CatalogDescriptor descriptor, String url) {
        return false;
    }

    private boolean handleNode(CatalogDescriptor descriptor, String url) {
        Matcher matcher = NODE_URL_PATTERN.matcher(url);
        String id = null;
        if (matcher.find()) {
            id = matcher.group(1);
        }
        Node node = new Node();
        node.setId(id);
        return this.handleNode(descriptor, url, (INode)node);
    }

    private boolean handleNodeContent(CatalogDescriptor descriptor, String url) {
        Matcher matcher = CONTENT_URL_PATTERN.matcher(url);
        String title = null;
        if (matcher.find()) {
            title = matcher.group(1);
        }
        Node node = new Node();
        node.setUrl(url);
        if (title != null) {
            int titleEnd;
            Object base = descriptor.getUrl().toExternalForm();
            if (!((String)base).endsWith("/")) {
                base = (String)base + "/";
            }
            if ((titleEnd = matcher.end()) > -1) {
                node.setUrl((String)base + url.substring(0, titleEnd));
            } else {
                node.setUrl((String)base + url);
            }
        }
        return this.handleNode(descriptor, url, (INode)node);
    }

    protected boolean handleNode(CatalogDescriptor descriptor, String url, INode node) {
        return false;
    }

    private boolean handleFeatured(CatalogDescriptor descriptor, String url) {
        Matcher matcher = Pattern.compile("(?:^|/)featured/(\\d+)(?:,(\\d+))?").matcher(url);
        String cat = null;
        String market = null;
        if (matcher.find()) {
            cat = matcher.group(1);
            if (matcher.groupCount() > 1) {
                market = matcher.group(2);
            }
        }
        return this.handleFeatured(descriptor, url, cat, market);
    }

    protected boolean handleFeatured(CatalogDescriptor descriptor, String url, String category, String market) {
        return false;
    }

    protected boolean handleTopFavorites(CatalogDescriptor descriptor, String url) {
        return false;
    }

    protected CatalogDescriptor handleUnknownCatalog(String url) {
        if (((String)url).startsWith("https:")) {
            url = "http:" + ((String)url).substring("https:".length());
            return CatalogRegistry.getInstance().findCatalogDescriptor((String)url);
        }
        if (((String)url).startsWith("http:")) {
            url = "https:" + ((String)url).substring("http:".length());
            return CatalogRegistry.getInstance().findCatalogDescriptor((String)url);
        }
        return null;
    }

    protected boolean handleInstallRequest(SolutionInstallationInfo installInfo, String url) {
        return false;
    }

    protected boolean handleImportFavoritesRequest(FavoritesDescriptor descriptor) {
        return false;
    }

    public static class FavoritesDescriptor {
        private final String favoritesUrl;
        private final CatalogDescriptor catalogDescriptor;

        public FavoritesDescriptor(String favoritesUrl, CatalogDescriptor catalogDescriptor) {
            this.favoritesUrl = favoritesUrl;
            this.catalogDescriptor = catalogDescriptor;
        }

        public String getFavoritesUrl() {
            return this.favoritesUrl;
        }

        public CatalogDescriptor getCatalogDescriptor() {
            return this.catalogDescriptor;
        }
    }

    public static class SolutionInstallationInfo {
        private String requestUrl;
        private String installId;
        private String state;
        private CatalogDescriptor catalogDescriptor;

        public SolutionInstallationInfo() {
        }

        public SolutionInstallationInfo(String installId, String state, CatalogDescriptor catalogDescriptor) {
            this.installId = installId;
            this.state = state;
            this.catalogDescriptor = catalogDescriptor;
        }

        public void setInstallId(String installId) {
            this.installId = installId;
        }

        public String getInstallId() {
            return this.installId;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getState() {
            return this.state;
        }

        public void setCatalogDescriptor(CatalogDescriptor catalogDescriptor) {
            this.catalogDescriptor = catalogDescriptor;
        }

        public CatalogDescriptor getCatalogDescriptor() {
            return this.catalogDescriptor;
        }

        public void setRequestUrl(String requestUrl) {
            this.requestUrl = requestUrl;
        }

        public String getRequestUrl() {
            return this.requestUrl;
        }
    }
}

