/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.preferences;

import java.io.File;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.CommonMessages;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.compatibility.CommonColors;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.RestoreTaskListAction;
import org.eclipse.mylyn.internal.tasks.ui.preferences.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class TasksUiPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.mylyn.tasks.ui.preferences";
    private static final String FORWARDSLASH = "/";
    private static final String BACKSLASH_MULTI = "\\\\";
    private static final int MS_MINUTES = 60000;
    private static BidiMap<String, Integer> SCHEDULE_TIME_MAP = new TreeBidiMap(Map.of("org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for.this.week", 0, "org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for.tomorrow", 1, "org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for.today", 2, "org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for.unscheduled", 3));
    private Button useRichEditor;
    private Button editorHighlightsCurrentLine;
    private Button useWebBrowser;
    private Text fullSyncScheduleTime;
    private Text relevantTasksSyncScheduleTime;
    private Button enableFullTaskListSynch;
    private Button enableRelevantTasksSynch;
    private Text taskDirectoryText;
    private Button browse;
    private Button notificationEnabledButton;
    private final FormToolkit toolkit;
    private Spinner timeoutMinutes;
    private Button timeoutEnabledButton;
    private ExpandableComposite advancedComposite;
    private Combo weekStartCombo;
    private Combo scheduleNewTasksCombo;
    private Button activityTrackingEnabledButton;
    private Label timeoutLabel1;
    private Label timeoutLabel2;
    private Button taskListTooltipEnabledButton;
    private Button showTaskTrimButton;
    private Button taskListServiceMessageEnabledButton;

    public TasksUiPreferencePage() {
        this.setPreferenceStore(TasksUiPlugin.getDefault().getPreferenceStore());
        this.toolkit = new FormToolkit(Display.getCurrent());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.createTaskRefreshScheduleGroup(container);
        this.createSchedulingGroup(container);
        this.createTaskNavigationGroup(container);
        this.createTaskListGroup(container);
        this.createTaskEditorGroup(container);
        Group taskActivityGroup = this.createTaskActivityGroup(container);
        if (!TasksUiPlugin.getTaskActivityMonitor().isEnabled()) {
            taskActivityGroup.setVisible(false);
            ((GridData)taskActivityGroup.getLayoutData()).exclude = true;
        }
        Composite advanced = this.createAdvancedSection(container);
        this.createTaskDataControl(advanced);
        if (this.getContainer() instanceof IWorkbenchPreferenceContainer) {
            String message = Messages.TasksUiPreferencePage_See_X_for_configuring_Task_List_colors;
            new PreferenceLinkArea(advanced, 0, "org.eclipse.ui.preferencePages.ColorsAndFonts", message, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        }
        this.createLinks(advanced);
        this.updateRefreshGroupEnablements();
        this.applyDialogFont(container);
        return container;
    }

    private void createLinks(Composite container) {
        Hyperlink link = new Hyperlink(container, 0);
        link.setForeground(CommonColors.HYPERLINK_WIDGET);
        link.setUnderlined(true);
        link.setText(Messages.TasksUiPreferencePage_Use_the_Restore_dialog_to_recover_missing_tasks);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                TasksUiPreferencePage.this.getShell().close();
                new RestoreTaskListAction().run();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }

    private Composite createAdvancedSection(Composite container) {
        this.advancedComposite = this.toolkit.createExpandableComposite(container, 290);
        this.advancedComposite.setFont(container.getFont());
        this.advancedComposite.setBackground(container.getBackground());
        this.advancedComposite.setText(Messages.TasksUiPreferencePage_Advanced);
        this.advancedComposite.setLayout((Layout)new GridLayout(1, false));
        this.advancedComposite.setLayoutData((Object)new GridData(768));
        this.advancedComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                TasksUiPreferencePage.this.getControl().getShell().pack();
            }
        });
        Composite advanced = new Composite((Composite)this.advancedComposite, 0);
        advanced.setLayout((Layout)new GridLayout(1, false));
        this.advancedComposite.setClient((Control)advanced);
        return advanced;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.notifications.enabled", this.notificationEnabledButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.reporting.open.editor", this.useRichEditor.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.editor.currentLineHighlight", this.editorHighlightsCurrentLine.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", this.enableFullTaskListSynch.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule", this.enableRelevantTasksSynch.getSelection());
        String miliseconds = this.toMillisecondsString(this.fullSyncScheduleTime.getText());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds", miliseconds);
        miliseconds = this.toMillisecondsString(this.relevantTasksSyncScheduleTime.getText());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule.miliseconds", miliseconds);
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.task.list.tool.tip", this.taskListTooltipEnabledButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.messages.enabled", this.taskListServiceMessageEnabledButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.show.trim", this.showTaskTrimButton.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.planning.week.start.day", this.getWeekStartValue());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for", this.getScheduleNewTasksValue());
        MonitorUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled", this.timeoutEnabledButton.getSelection());
        MonitorUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.activity.timeout", this.timeoutMinutes.getSelection() * 60000);
        MonitorUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.activity.tracking.enabled", this.activityTrackingEnabledButton.getSelection());
        String taskDirectory = this.taskDirectoryText.getText();
        taskDirectory = taskDirectory.replaceAll(BACKSLASH_MULTI, FORWARDSLASH);
        if (!taskDirectory.equals(TasksUiPlugin.getDefault().getDataDirectory())) {
            if (this.checkForExistingTasklist(taskDirectory)) {
                String originalDirectory;
                Throwable exception = null;
                try {
                    TasksUiPlugin.getDefault().setDataDirectory(taskDirectory);
                }
                catch (CoreException e) {
                    exception = e;
                    StatusHandler.log((IStatus)e.getStatus());
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.TasksUiPreferencePage_Task_Data_Directory_Error, (String)Messages.TasksUiPreferencePage_Error_applying_Task_List_data_directory_changes);
                }
                catch (OperationCanceledException ce) {
                    exception = ce;
                }
                if (exception != null && !this.taskDirectoryText.isDisposed() && !taskDirectory.equals(originalDirectory = TasksUiPlugin.getDefault().getDefaultDataDirectory())) {
                    this.taskDirectoryText.setText(originalDirectory);
                }
            } else {
                this.taskDirectoryText.setFocus();
                return false;
            }
        }
        return true;
    }

    private String toMillisecondsString(String minutesString) {
        return Long.toString(60000L * Long.parseLong(minutesString));
    }

    private int getWeekStartValue() {
        return this.weekStartCombo.getSelectionIndex() + 1;
    }

    private String getScheduleNewTasksValue() {
        int index = this.scheduleNewTasksCombo.getSelectionIndex();
        return (String)SCHEDULE_TIME_MAP.inverseBidiMap().get((Object)index);
    }

    public boolean performCancel() {
        this.taskDirectoryText.setText(TasksUiPlugin.getDefault().getDefaultDataDirectory());
        this.notificationEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.notifications.enabled"));
        this.useRichEditor.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor"));
        this.editorHighlightsCurrentLine.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.editor.currentLineHighlight"));
        String repositorySyncMinutes = this.toMinutesString(this.getPreferenceStore().getLong("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds"));
        String relevantSyncMinutes = this.toMinutesString(this.getPreferenceStore().getLong("org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule.miliseconds"));
        boolean shouldSyncTaskList = this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule");
        boolean shouldSyncRelevantTasks = this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule");
        this.enableFullTaskListSynch.setSelection(shouldSyncTaskList);
        this.enableRelevantTasksSynch.setSelection(shouldSyncRelevantTasks);
        this.fullSyncScheduleTime.setText(repositorySyncMinutes);
        this.relevantTasksSyncScheduleTime.setText(relevantSyncMinutes);
        this.taskListTooltipEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.task.list.tool.tip"));
        this.taskListServiceMessageEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.messages.enabled"));
        this.showTaskTrimButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.show.trim"));
        this.weekStartCombo.select(this.getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.week.start.day") - 1);
        String scheduleFor = this.getPreferenceStore().getString("org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for");
        this.scheduleNewTasksCombo.select(((Integer)SCHEDULE_TIME_MAP.getOrDefault((Object)scheduleFor, (Object)0)).intValue());
        int minutes = MonitorUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.monitor.ui.activity.timeout") / 60000;
        this.timeoutMinutes.setSelection(minutes);
        this.timeoutEnabledButton.setSelection(MonitorUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled"));
        this.activityTrackingEnabledButton.setSelection(MonitorUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.activity.tracking.enabled"));
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        this.taskDirectoryText.setText(TasksUiPlugin.getDefault().getDefaultDataDirectory());
        this.notificationEnabledButton.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.notifications.enabled"));
        this.useRichEditor.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor"));
        this.editorHighlightsCurrentLine.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.editor.currentLineHighlight"));
        this.taskListTooltipEnabledButton.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.task.list.tool.tip"));
        this.taskListServiceMessageEnabledButton.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.messages.enabled"));
        this.showTaskTrimButton.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.show.trim"));
        this.enableFullTaskListSynch.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule"));
        this.enableRelevantTasksSynch.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule"));
        this.fullSyncScheduleTime.setText(this.toMinutesString(this.getPreferenceStore().getDefaultLong("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds")));
        this.relevantTasksSyncScheduleTime.setText(this.toMinutesString(this.getPreferenceStore().getDefaultLong("org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule.miliseconds")));
        this.weekStartCombo.select(this.getPreferenceStore().getDefaultInt("org.eclipse.mylyn.tasks.ui.planning.week.start.day") - 1);
        String defaultScheduleFor = this.getPreferenceStore().getDefaultString("org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for");
        this.scheduleNewTasksCombo.select(((Integer)SCHEDULE_TIME_MAP.getOrDefault((Object)defaultScheduleFor, (Object)0)).intValue());
        int activityTimeoutMinutes = MonitorUiPlugin.getDefault().getPreferenceStore().getDefaultInt("org.eclipse.mylyn.monitor.ui.activity.timeout") / 60000;
        this.timeoutMinutes.setSelection(activityTimeoutMinutes);
        this.timeoutEnabledButton.setSelection(MonitorUiPlugin.getDefault().getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled"));
        this.activityTrackingEnabledButton.setSelection(MonitorUiPlugin.getDefault().getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.monitor.activity.tracking.enabled"));
        this.updateRefreshGroupEnablements();
    }

    private void createTaskRefreshScheduleGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Messages.TasksUiPreferencePage_Synchronization);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        Composite backgroundSync = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(4).equalWidth(false).margins(0, 0).applyTo(backgroundSync);
        this.enableFullTaskListSynch = new Button(backgroundSync, 32);
        this.enableFullTaskListSynch.setText(Messages.TasksUiPreferencePage_Synchronize_Task_List);
        this.enableFullTaskListSynch.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule"));
        this.enableFullTaskListSynch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridDataFactory.defaultsFor((Control)this.enableFullTaskListSynch).span(4, 1).applyTo((Control)this.enableFullTaskListSynch);
        new Label(backgroundSync, 0).setText(Messages.TasksUiPreferencePage_Synchronize_Queries);
        this.fullSyncScheduleTime = this.createSynchronizationScheduleTextBox(backgroundSync, "org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds");
        new Label(backgroundSync, 0).setText(Messages.TasksUiPreferencePage_minutes);
        new Label(backgroundSync, 0);
        this.enableRelevantTasksSynch = new Button(backgroundSync, 32);
        this.enableRelevantTasksSynch.setText(Messages.TasksUiPreferencePage_Synchronize_Relevant_Tasks);
        this.enableRelevantTasksSynch.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule"));
        this.enableRelevantTasksSynch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.relevantTasksSyncScheduleTime = this.createSynchronizationScheduleTextBox(backgroundSync, "org.eclipse.mylyn.tasks.ui.relevant.tasks.synch.schedule.miliseconds");
        new Label(backgroundSync, 0).setText(Messages.TasksUiPreferencePage_minutes);
        Label help = new Label(backgroundSync, 0);
        help.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.QUESTION));
        help.setToolTipText(Messages.TasksUiPreferencePage_RelevantTasksHelp);
        this.notificationEnabledButton = new Button((Composite)group, 32);
        this.notificationEnabledButton.setText(Messages.TasksUiPreferencePage_Display_notifications_for_overdue_tasks_and_incoming_changes);
        this.notificationEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.notifications.enabled"));
        GridDataFactory.defaultsFor((Control)this.notificationEnabledButton).span(4, 1).applyTo((Control)this.notificationEnabledButton);
    }

    private Text createSynchronizationScheduleTextBox(Composite backgroundSync, String preferenceKey) {
        Text text = new Text(backgroundSync, 133120);
        GridData gridDataRepo = new GridData();
        gridDataRepo.widthHint = 25;
        text.setLayoutData((Object)gridDataRepo);
        long querySyncMilliseconds = this.getPreferenceStore().getLong(preferenceKey);
        text.setText(this.toMinutesString(querySyncMilliseconds));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        return text;
    }

    private void createTaskEditorGroup(Composite parent) {
        Group container = new Group(parent, 16);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(768));
        container.setText(Messages.TasksUiPreferencePage_Task_Editing);
        this.useRichEditor = new Button((Composite)container, 16);
        this.useRichEditor.setText(Messages.TasksUiPreferencePage_Rich_Editor__Recommended_);
        this.useRichEditor.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor"));
        this.useWebBrowser = new Button((Composite)container, 16);
        this.useWebBrowser.setText(Messages.TasksUiPreferencePage_Web_Browser);
        this.useWebBrowser.setSelection(!this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor"));
        this.editorHighlightsCurrentLine = new Button((Composite)container, 32);
        this.editorHighlightsCurrentLine.setText(Messages.TasksUiPreferencePage_highlight_current_line);
        this.editorHighlightsCurrentLine.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.editor.currentLineHighlight"));
    }

    private void createTaskDataControl(Composite parent) {
        Group taskDataGroup = new Group(parent, 16);
        taskDataGroup.setText(Messages.TasksUiPreferencePage_Task_Data);
        taskDataGroup.setLayout((Layout)new GridLayout(1, false));
        taskDataGroup.setLayoutData((Object)new GridData(768));
        Composite dataDirComposite = new Composite((Composite)taskDataGroup, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        dataDirComposite.setLayout((Layout)gridLayout);
        dataDirComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(dataDirComposite, 0);
        label.setText(Messages.TasksUiPreferencePage_Data_directory_);
        String taskDirectory = TasksUiPlugin.getDefault().getDataDirectory();
        taskDirectory = taskDirectory.replaceAll(BACKSLASH_MULTI, FORWARDSLASH);
        this.taskDirectoryText = new Text(dataDirComposite, 2048);
        this.taskDirectoryText.setText(taskDirectory);
        this.taskDirectoryText.setLayoutData((Object)new GridData(768));
        this.browse = new Button(dataDirComposite, 131072);
        this.browse.setText(Messages.TasksUiPreferencePage_Browse_);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(TasksUiPreferencePage.this.getShell());
                dialog.setText(Messages.TasksUiPreferencePage_Folder_Selection);
                dialog.setMessage(Messages.TasksUiPreferencePage_Specify_the_folder_for_tasks);
                String dir = TasksUiPreferencePage.this.taskDirectoryText.getText();
                dir = dir.replaceAll(TasksUiPreferencePage.BACKSLASH_MULTI, TasksUiPreferencePage.FORWARDSLASH);
                dialog.setFilterPath(dir);
                dir = dialog.open();
                if (dir == null || dir.equals("")) {
                    return;
                }
                dir = dir.replaceAll(TasksUiPreferencePage.BACKSLASH_MULTI, TasksUiPreferencePage.FORWARDSLASH);
                TasksUiPreferencePage.this.taskDirectoryText.setText(dir);
            }
        });
    }

    private void createSchedulingGroup(Composite container) {
        Group group = new Group(container, 16);
        group.setText(Messages.TasksUiPreferencePage_Scheduling);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        Label weekStartLabel = new Label((Composite)group, 0);
        weekStartLabel.setText(Messages.TasksUiPreferencePage_Week_Start);
        this.weekStartCombo = new Combo((Composite)group, 8);
        this.weekStartCombo.add(CommonMessages.Sunday);
        this.weekStartCombo.add(CommonMessages.Monday);
        this.weekStartCombo.add(CommonMessages.Tuesday);
        this.weekStartCombo.add(CommonMessages.Wednesday);
        this.weekStartCombo.add(CommonMessages.Thursday);
        this.weekStartCombo.add(CommonMessages.Friday);
        this.weekStartCombo.add(CommonMessages.Saturday);
        this.weekStartCombo.select(this.getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.week.start.day") - 1);
        Label scheduleNewTasksLabel = new Label((Composite)group, 0);
        scheduleNewTasksLabel.setText(Messages.TasksUiPreferencePage_ScheduleNewTasks);
        this.scheduleNewTasksCombo = new Combo((Composite)group, 8);
        this.scheduleNewTasksCombo.add(Messages.TasksUiPreferencePage_ThisWeek);
        this.scheduleNewTasksCombo.add(Messages.TasksUiPreferencePage_Tomorrow);
        this.scheduleNewTasksCombo.add(Messages.TasksUiPreferencePage_Today);
        this.scheduleNewTasksCombo.add(Messages.TasksUiPreferencePage_Unscheduled);
        String scheduleFor = this.getPreferenceStore().getString("org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for");
        this.scheduleNewTasksCombo.select(((Integer)SCHEDULE_TIME_MAP.getOrDefault((Object)scheduleFor, (Object)0)).intValue());
    }

    private void createTaskNavigationGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.TasksUiPreferencePage_Task_Navigation_Group_Label);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout());
        this.showTaskTrimButton = new Button((Composite)group, 32);
        this.showTaskTrimButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.showTaskTrimButton.setText(Messages.TasksUiPreferencePage_Show_active_task_trim_Button_Label);
        this.showTaskTrimButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.show.trim"));
    }

    private void createTaskListGroup(Composite container) {
        Group group = new Group(container, 16);
        group.setText(Messages.TasksUiPreferencePage_Task_List_Group);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        this.taskListTooltipEnabledButton = new Button((Composite)group, 32);
        this.taskListTooltipEnabledButton.setText(Messages.TasksUiPreferencePage_Show_tooltip_on_hover_Label);
        this.taskListTooltipEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.task.list.tool.tip"));
        this.taskListServiceMessageEnabledButton = new Button((Composite)group, 32);
        this.taskListServiceMessageEnabledButton.setText(Messages.TasksUiPreferencePage_Notification_for_new_connectors_available_Label);
        this.taskListServiceMessageEnabledButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.messages.enabled"));
    }

    private Group createTaskActivityGroup(Composite container) {
        Group group = new Group(container, 16);
        group.setText(Messages.TasksUiPreferencePage_Task_Timing);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        boolean activityTrackingEnabled = MonitorUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.activity.tracking.enabled");
        boolean timeoutEnabled = MonitorUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled");
        this.activityTrackingEnabledButton = new Button((Composite)group, 32);
        this.activityTrackingEnabledButton.setText(Messages.TasksUiPreferencePage_Enable_Time_Tracking);
        this.activityTrackingEnabledButton.setSelection(activityTrackingEnabled);
        this.activityTrackingEnabledButton.setToolTipText(Messages.TasksUiPreferencePage_Track_Time_Spent);
        this.activityTrackingEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.activityTrackingEnabledButton);
        this.timeoutEnabledButton = new Button((Composite)group, 32);
        this.timeoutEnabledButton.setText(Messages.TasksUiPreferencePage_Enable_inactivity_timeouts);
        this.timeoutEnabledButton.setSelection(timeoutEnabled);
        this.timeoutEnabledButton.setToolTipText(Messages.TasksUiPreferencePage_If_disabled);
        this.timeoutEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.timeoutEnabledButton);
        this.timeoutLabel1 = new Label((Composite)group, 0);
        this.timeoutLabel1.setText(Messages.TasksUiPreferencePage_Stop_time_accumulation_after);
        this.timeoutMinutes = new Spinner((Composite)group, 2048);
        this.timeoutMinutes.setDigits(0);
        this.timeoutMinutes.setIncrement(5);
        this.timeoutMinutes.setMaximum(60);
        this.timeoutMinutes.setMinimum(1);
        long minutes = MonitorUiPlugin.getDefault().getPreferenceStore().getLong("org.eclipse.mylyn.monitor.ui.activity.timeout") / 60000L;
        this.timeoutMinutes.setSelection((int)minutes);
        this.timeoutMinutes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TasksUiPreferencePage.this.updateRefreshGroupEnablements();
            }
        });
        this.timeoutLabel2 = new Label((Composite)group, 0);
        this.timeoutLabel2.setText(Messages.TasksUiPreferencePage_minutes_of_inactivity);
        return group;
    }

    public void updateRefreshGroupEnablements() {
        String errorMessage = null;
        boolean synchronizeTaskList = this.enableFullTaskListSynch.getSelection();
        if (synchronizeTaskList && (errorMessage = this.validateSynchronizeSchedule(this.fullSyncScheduleTime)) == null) {
            errorMessage = this.validateSynchronizeSchedule(this.relevantTasksSyncScheduleTime);
        }
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
        if (this.activityTrackingEnabledButton.getSelection()) {
            this.timeoutEnabledButton.setEnabled(true);
            this.timeoutMinutes.setEnabled(this.timeoutEnabledButton.getSelection());
            this.timeoutLabel1.setEnabled(this.timeoutEnabledButton.getSelection());
            this.timeoutLabel2.setEnabled(this.timeoutEnabledButton.getSelection());
        } else {
            this.timeoutEnabledButton.setEnabled(false);
            this.timeoutMinutes.setEnabled(false);
            this.timeoutLabel1.setEnabled(false);
            this.timeoutLabel2.setEnabled(false);
        }
        boolean synchronizeRelevantTasks = synchronizeTaskList && this.enableRelevantTasksSynch.getSelection();
        this.enableRelevantTasksSynch.setEnabled(synchronizeTaskList);
        this.fullSyncScheduleTime.setEnabled(synchronizeTaskList);
        this.relevantTasksSyncScheduleTime.setEnabled(synchronizeRelevantTasks);
    }

    private String validateSynchronizeSchedule(Text synchronizeText) {
        String errorMessage = null;
        try {
            long number = Long.parseLong(synchronizeText.getText());
            if (number <= 0L) {
                errorMessage = Messages.TasksUiPreferencePage_Synchronize_schedule_time_must_be_GT_0;
            }
        }
        catch (NumberFormatException e) {
            errorMessage = Messages.TasksUiPreferencePage_Synchronize_schedule_time_must_be_valid_integer;
        }
        return errorMessage;
    }

    private String toMinutesString(long miliseconds) {
        long minutes = miliseconds / 60000L;
        return Long.toString(minutes);
    }

    private boolean checkForExistingTasklist(String dir) {
        File newDataFolder = new File(dir);
        if (!newDataFolder.exists() && !newDataFolder.mkdirs()) {
            MessageDialog.openWarning((Shell)this.getControl().getShell(), (String)Messages.TasksUiPreferencePage_Change_data_directory, (String)Messages.TasksUiPreferencePage_Destination_folder_cannot_be_created);
            return false;
        }
        MessageDialog dialogConfirm = new MessageDialog(null, Messages.TasksUiPreferencePage_Confirm_Task_List_data_directory_change, null, Messages.TasksUiPreferencePage_A_new_empty_Task_List_will_be_created_in_the_chosen_directory_if_one_does_not_already_exists, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
        int taskDataDirectoryAction = dialogConfirm.open();
        if (taskDataDirectoryAction != 0) {
            return false;
        }
        for (TaskEditor taskEditor : TasksUiInternal.getActiveRepositoryTaskEditors()) {
            TasksUiInternal.closeTaskEditorInAllPages(taskEditor.getTaskEditorInput().getTask(), true);
        }
        return true;
    }

    public void dispose() {
        if (this.toolkit != null && this.toolkit.getColors() != null) {
            this.toolkit.dispose();
        }
        super.dispose();
    }
}

