/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.Window;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.compatibility.CommonFonts;
import org.eclipse.mylyn.internal.tasks.ui.dialogs.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.LegendElement;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.themes.IThemeManager;

public class UiLegendControl
extends Composite {
    private final FormToolkit toolkit;
    private Window window = null;
    private final TaskElementLabelProvider labelProvider = new TaskElementLabelProvider(false);
    private final IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
    private final ArrayList<LegendElement> legendElements = new ArrayList();

    public UiLegendControl(Composite parent, FormToolkit toolkit) {
        this(parent, toolkit, true, 512);
    }

    public UiLegendControl(Composite parent, FormToolkit toolkit, boolean showConnectors, int style) {
        super(parent, 0);
        this.toolkit = toolkit;
        toolkit.adapt((Composite)this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UiLegendControl.this.doDispose();
            }
        });
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        if (style == -1) {
            this.createContentsVertical(layout, showConnectors);
        } else if ((style & 0x100) != 0) {
            this.createContentsHorizontal(layout, showConnectors);
        } else {
            this.createContentsVertical(layout, showConnectors);
        }
        this.setLayout((Layout)layout);
        this.setLayoutData(new TableWrapData(256, 256));
    }

    private void doDispose() {
        for (LegendElement element : this.legendElements) {
            element.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    public boolean close() {
        if (this.window != null) {
            return this.window.close();
        }
        return false;
    }

    private void createContentsHorizontal(TableWrapLayout layout, boolean showConnectors) {
        layout.numColumns = 2;
        this.createTasksPrioritiesSection(this);
        this.createContextSection(this);
        this.createActivitySection(this);
        this.createSynchronizationSection(this);
        Composite subComp = this.toolkit.createComposite((Composite)this);
        TableWrapLayout subLayout = new TableWrapLayout();
        subLayout.topMargin = 0;
        subLayout.bottomMargin = 0;
        subLayout.leftMargin = 0;
        subLayout.rightMargin = 0;
        subComp.setLayout((Layout)subLayout);
        subComp.setLayoutData((Object)new TableWrapData(256, 256, 1, 2));
        if (showConnectors) {
            this.createConnectorsSection(subComp);
        }
        this.createGettingStartedSection(subComp);
    }

    private void createContentsVertical(TableWrapLayout layout, boolean showConnectors) {
        layout.numColumns = 1;
        this.createTasksPrioritiesSection(this);
        this.createActivitySection(this);
        this.createContextSection(this);
        this.createSynchronizationSection(this);
        if (showConnectors) {
            this.createConnectorsSection(this);
        }
        this.createGettingStartedSection(this);
    }

    private void createTasksPrioritiesSection(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        Composite composite = this.toolkit.createComposite(parent);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new TableWrapData(256));
        this.createTasksSection(composite);
        this.createPrioritiesSection(composite);
    }

    private void createTasksSection(Composite parent) {
        Section tasksSection = this.toolkit.createSection(parent, 256);
        tasksSection.setText(Messages.UiLegendControl_Tasks);
        tasksSection.setLayout((Layout)new TableWrapLayout());
        tasksSection.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 1;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite tasksClient = this.toolkit.createComposite((Composite)tasksSection);
        tasksClient.setLayout((Layout)layout);
        tasksClient.setLayoutData((Object)new TableWrapData(256));
        tasksSection.setClient((Control)tasksClient);
        Label imageLabel = this.toolkit.createLabel(tasksClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        this.toolkit.createLabel(tasksClient, Messages.UiLegendControl_Task);
        imageLabel = this.toolkit.createLabel(tasksClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK_OWNED));
        this.toolkit.createLabel(tasksClient, Messages.UiLegendControl_Task_Owned);
        imageLabel = this.toolkit.createLabel(tasksClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CATEGORY));
        this.toolkit.createLabel(tasksClient, Messages.UiLegendControl_Category);
        imageLabel = this.toolkit.createLabel(tasksClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.QUERY));
        this.toolkit.createLabel(tasksClient, Messages.UiLegendControl_Query);
        imageLabel = this.toolkit.createLabel(tasksClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.CALENDAR));
        this.toolkit.createLabel(tasksClient, Messages.UiLegendControl_Date_range);
        imageLabel = this.toolkit.createLabel(tasksClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.BLANK));
        Hyperlink openView = this.toolkit.createHyperlink(tasksClient, Messages.UiLegendControl_Open_Task_List_, 64);
        openView.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                UiLegendControl.this.close();
                TasksUiUtil.openTasksViewInActivePerspective();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }

    private void createPrioritiesSection(Composite parent) {
        Section prioritiesSection = this.toolkit.createSection(parent, 256);
        prioritiesSection.setText(Messages.UiLegendControl_Priorities);
        prioritiesSection.setLayout((Layout)new TableWrapLayout());
        prioritiesSection.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 1;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite prioritiesClient = this.toolkit.createComposite((Composite)prioritiesSection);
        prioritiesClient.setLayout((Layout)layout);
        prioritiesClient.setLayoutData((Object)new TableWrapData(256));
        prioritiesSection.setClient((Control)prioritiesClient);
        Label imageLabel = this.toolkit.createLabel(prioritiesClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PRIORITY_1));
        this.toolkit.createLabel(prioritiesClient, ITask.PriorityLevel.P1.getDescription());
        imageLabel = this.toolkit.createLabel(prioritiesClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PRIORITY_2));
        this.toolkit.createLabel(prioritiesClient, ITask.PriorityLevel.P2.getDescription());
        imageLabel = this.toolkit.createLabel(prioritiesClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PRIORITY_3));
        this.toolkit.createLabel(prioritiesClient, ITask.PriorityLevel.P3.getDescription() + Messages.UiLegendControl__default_);
        imageLabel = this.toolkit.createLabel(prioritiesClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PRIORITY_4));
        this.toolkit.createLabel(prioritiesClient, ITask.PriorityLevel.P4.getDescription());
        imageLabel = this.toolkit.createLabel(prioritiesClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PRIORITY_5));
        this.toolkit.createLabel(prioritiesClient, ITask.PriorityLevel.P5.getDescription());
    }

    private void createActivitySection(Composite parent) {
        Section activitySection = this.toolkit.createSection(parent, 256);
        activitySection.setText(Messages.UiLegendControl_Task_Activity);
        activitySection.setLayout((Layout)new TableWrapLayout());
        activitySection.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 1;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite activityClient = this.toolkit.createComposite((Composite)activitySection);
        activityClient.setLayout((Layout)layout);
        activityClient.setLayoutData((Object)new TableWrapData(256));
        activitySection.setClient((Control)activityClient);
        Label imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        Label labelToday = this.toolkit.createLabel(activityClient, Messages.UiLegendControl_Scheduled_for_today);
        labelToday.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.today.scheduled"));
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        Label labelOverdue = this.toolkit.createLabel(activityClient, Messages.UiLegendControl_Past_scheduled_date);
        labelOverdue.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.past.scheduled"));
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        Label labelCompleted = this.toolkit.createLabel(activityClient, Messages.UiLegendControl_Completed);
        labelCompleted.setFont(CommonFonts.STRIKETHROUGH);
        labelCompleted.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.completed"));
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        Label labelCompletedToday = this.toolkit.createLabel(activityClient, Messages.UiLegendControl_Completed_today);
        labelCompletedToday.setFont(CommonFonts.STRIKETHROUGH);
        labelCompletedToday.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.today.completed"));
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_DATE_DUE));
        this.toolkit.createLabel(activityClient, Messages.UiLegendControl_Has_Due_date);
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_DATE_OVERDUE));
        Label textLabel = this.toolkit.createLabel(activityClient, Messages.UiLegendControl_Past_due_date);
        textLabel.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.past.due"));
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.NOTES));
        this.toolkit.createLabel(activityClient, Messages.UiLegendControl_Notes);
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.BLANK));
        Hyperlink adjust = this.toolkit.createHyperlink(activityClient, Messages.UiLegendControl_Adjust_Colors_and_Fonts_, 64);
        adjust.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.eclipse.ui.preferencePages.ColorsAndFonts", (String[])new String[]{"org.eclipse.ui.preferencePages.ColorsAndFonts"}, null);
                dlg.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }

    private void createContextSection(Composite parent) {
        Section contextSection = this.toolkit.createSection(parent, 256);
        contextSection.setText(Messages.UiLegendControl_Task_Context);
        contextSection.setLayout((Layout)new TableWrapLayout());
        contextSection.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 1;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite contextClient = this.toolkit.createComposite((Composite)contextSection);
        contextClient.setLayout((Layout)layout);
        contextClient.setLayoutData((Object)new TableWrapData(256));
        contextSection.setClient((Control)contextClient);
        Label imageLabel = this.toolkit.createLabel(contextClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_FOCUS));
        this.toolkit.createLabel(contextClient, Messages.UiLegendControl_Focus_view_on_active_task);
        imageLabel = this.toolkit.createLabel(contextClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_INACTIVE_EMPTY));
        this.toolkit.createLabel(contextClient, Messages.UiLegendControl_Inactive_task_with_no_context);
        imageLabel = this.toolkit.createLabel(contextClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_INACTIVE));
        this.toolkit.createLabel(contextClient, Messages.UiLegendControl_Inactive_task_with_context);
        imageLabel = this.toolkit.createLabel(contextClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_ACTIVE));
        this.toolkit.createLabel(contextClient, Messages.UiLegendControl_Active_task);
    }

    private void createSynchronizationSection(Composite parent) {
        Section synchroSection = this.toolkit.createSection(parent, 256);
        synchroSection.setText(Messages.UiLegendControl_Synchronization);
        synchroSection.setLayout((Layout)new TableWrapLayout());
        synchroSection.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 3;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite synchroClient = this.toolkit.createComposite((Composite)synchroSection);
        synchroClient.setLayout((Layout)layout);
        synchroClient.setLayoutData((Object)new TableWrapData(256));
        synchroSection.setClient((Control)synchroClient);
        Label imageLabel = this.toolkit.createLabel(synchroClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_INCOMMING_NEW));
        this.toolkit.createLabel(synchroClient, Messages.UiLegendControl_New_task);
        imageLabel = this.toolkit.createLabel(synchroClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_INCOMMING));
        this.toolkit.createLabel(synchroClient, Messages.UiLegendControl_Incoming_changes);
        imageLabel = this.toolkit.createLabel(synchroClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_OUTGOING));
        this.toolkit.createLabel(synchroClient, Messages.UiLegendControl_Outgoing_changes);
        imageLabel = this.toolkit.createLabel(synchroClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_OUTGOING_NEW));
        this.toolkit.createLabel(synchroClient, Messages.UiLegendControl_Unsubmitted_outgoing_changes);
        imageLabel = this.toolkit.createLabel(synchroClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_WARNING));
        this.toolkit.createLabel(synchroClient, Messages.UiLegendControl_Synchronization_failed);
        imageLabel = this.toolkit.createLabel(synchroClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_ERROR));
        this.toolkit.createLabel(synchroClient, Messages.UiLegendControl_Synchronization_error);
        imageLabel = this.toolkit.createLabel(synchroClient, "");
        imageLabel.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_CONFLICT));
        this.toolkit.createLabel(synchroClient, Messages.UiLegendControl_Conflicting_changes);
    }

    private void createConnectorsSection(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.makeColumnsEqualWidth = true;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        ScrolledForm composite = this.toolkit.createScrolledForm(parent);
        composite.getBody().setLayout((Layout)layout);
        TableWrapData data = new TableWrapData(128);
        composite.setLayoutData((Object)data);
        ArrayList connectors = new ArrayList(TasksUi.getRepositoryManager().getRepositoryConnectors());
        Collections.sort(connectors, new Comparator<AbstractRepositoryConnector>(){

            @Override
            public int compare(AbstractRepositoryConnector o1, AbstractRepositoryConnector o2) {
                return o1.getLabel().compareToIgnoreCase(o2.getLabel());
            }
        });
        for (AbstractRepositoryConnector connector : connectors) {
            List<LegendElement> elements;
            AbstractRepositoryConnectorUi connectorUi;
            if (TasksUi.getRepositoryManager().getRepositories(connector.getConnectorKind()).isEmpty() || (connectorUi = TasksUi.getRepositoryConnectorUi(connector.getConnectorKind())) == null || (elements = connectorUi.getLegendElements()) == null || elements.size() <= 0) continue;
            this.legendElements.addAll(elements);
            this.addLegendElements(composite.getBody(), connector, elements);
        }
        layout.numColumns = Math.max(composite.getBody().getChildren().length, 1);
        Point w = composite.computeSize(-1, -1);
        data.maxWidth = w.x / layout.numColumns * 3;
    }

    private void addLegendElements(Composite composite, AbstractRepositoryConnector connector, List<LegendElement> elements) {
        Label imageLabel;
        Section connectorSection = this.toolkit.createSection(composite, 256);
        connectorSection.setLayout((Layout)new TableWrapLayout());
        connectorSection.setLayoutData((Object)new TableWrapData(256));
        String label = connector.getLabel();
        int parenIndex = label.indexOf(40);
        if (parenIndex != -1) {
            label = label.substring(0, parenIndex);
        }
        connectorSection.setText(label);
        TableWrapLayout clientLayout = new TableWrapLayout();
        clientLayout.numColumns = 2;
        clientLayout.makeColumnsEqualWidth = false;
        clientLayout.verticalSpacing = 1;
        clientLayout.topMargin = 1;
        clientLayout.bottomMargin = 1;
        Composite connectorClient = this.toolkit.createComposite((Composite)connectorSection);
        connectorClient.setLayout((Layout)clientLayout);
        connectorClient.setLayoutData((Object)new TableWrapData(256));
        connectorSection.setClient((Control)connectorClient);
        for (LegendElement element : elements) {
            imageLabel = this.toolkit.createLabel(connectorClient, "");
            imageLabel.setImage(element.getImage());
            this.toolkit.createLabel(connectorClient, element.getLabel());
        }
        if (elements.size() < 4) {
            imageLabel = this.toolkit.createLabel(connectorClient, "");
            this.toolkit.createLabel(connectorClient, "");
        }
    }

    private void createGettingStartedSection(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        Composite hyperlinkClient = this.toolkit.createComposite(parent);
        hyperlinkClient.setLayout((Layout)layout);
        hyperlinkClient.setLayoutData((Object)new TableWrapData(256));
        Hyperlink gettingStartedLink = this.toolkit.createHyperlink(hyperlinkClient, Messages.UiLegendControl_Also_see_the_Getting_Started_documentation_online, 64);
        gettingStartedLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                UiLegendControl.this.close();
                TasksUiUtil.openUrl(Messages.UiLegendControl_http_www_eclipse_org_mylyn_start);
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }
}

