/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.ConsoleFactoryExtension;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsolePageParticipantExtension;
import org.eclipse.ui.internal.console.ConsoleView;
import org.eclipse.ui.internal.console.PatternMatchListener;
import org.eclipse.ui.internal.console.PatternMatchListenerExtension;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class ConsoleManager
implements IConsoleManager {
    private final ListenerList<IConsoleListener> fListeners = new ListenerList();
    private final List<IConsole> fConsoles = new ArrayList<IConsole>(10);
    private static final int ADDED = 1;
    private static final int REMOVED = 2;
    private List<PatternMatchListenerExtension> fPatternMatchListeners;
    private List<ConsolePageParticipantExtension> fPageParticipants;
    private List<ConsoleFactoryExtension> fConsoleFactoryExtensions;
    private final List<IConsoleView> fConsoleViews = new ArrayList<IConsoleView>();
    private boolean fWarnQueued = false;
    private final RepaintJob fRepaintJob = new RepaintJob();
    private final ShowConsoleViewJob showJob = new ShowConsoleViewJob();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConsoleView(ConsoleView view) {
        List<IConsoleView> list = this.fConsoleViews;
        synchronized (list) {
            this.fConsoleViews.add(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConsoleView(ConsoleView view) {
        List<IConsoleView> list = this.fConsoleViews;
        synchronized (list) {
            this.fConsoleViews.remove(view);
        }
    }

    @Override
    public void addConsoleListener(IConsoleListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removeConsoleListener(IConsoleListener listener) {
        this.fListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsoles(IConsole[] consoles) {
        ArrayList<IConsole> added = new ArrayList<IConsole>(consoles.length);
        List<IConsole> list = this.fConsoles;
        synchronized (list) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console instanceof TextConsole) {
                    TextConsole ioconsole = (TextConsole)console;
                    this.createPatternMatchListeners(ioconsole);
                }
                if (!this.fConsoles.contains(console)) {
                    this.fConsoles.add(console);
                    added.add(console);
                }
                ++n2;
            }
        }
        if (!added.isEmpty()) {
            this.fireUpdate(added.toArray(new IConsole[added.size()]), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsoles(IConsole[] consoles) {
        ArrayList<IConsole> removed = new ArrayList<IConsole>(consoles.length);
        List<IConsole> list = this.fConsoles;
        synchronized (list) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (this.fConsoles.remove(console)) {
                    removed.add(console);
                }
                ++n2;
            }
        }
        if (!removed.isEmpty()) {
            this.fireUpdate(removed.toArray(new IConsole[removed.size()]), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConsole[] getConsoles() {
        List<IConsole> list = this.fConsoles;
        synchronized (list) {
            return this.fConsoles.toArray(new IConsole[this.fConsoles.size()]);
        }
    }

    private void fireUpdate(IConsole[] consoles, int type) {
        new ConsoleNotifier().notify(consoles, type);
    }

    @Override
    public void showConsoleView(IConsole console) {
        this.showJob.addConsole(console);
        this.showJob.schedule(100L);
    }

    private boolean shouldBringToTop(IConsole console, IViewPart consoleView) {
        IConsoleView cView;
        boolean bringToTop = true;
        if (consoleView instanceof IConsoleView && (cView = (IConsoleView)consoleView).isPinned()) {
            IConsole pinnedConsole = cView.getConsole();
            bringToTop = console.equals(pinnedConsole);
        }
        return bringToTop;
    }

    @Override
    public void warnOfContentChange(final IConsole console) {
        if (!this.fWarnQueued) {
            this.fWarnQueued = true;
            UIJob job = new UIJob(ConsolePlugin.getStandardDisplay(), ConsoleMessages.ConsoleManager_consoleContentChangeJob){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IConsoleView consoleView;
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null && (consoleView = (IConsoleView)page.findView("org.eclipse.ui.console.ConsoleView")) != null) {
                        consoleView.warnOfContentChange(console);
                    }
                    ConsoleManager.this.fWarnQueued = false;
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    @Override
    public IPatternMatchListener[] createPatternMatchListeners(IConsole console) {
        if (this.fPatternMatchListeners == null) {
            IConfigurationElement[] elements;
            this.fPatternMatchListeners = new ArrayList<PatternMatchListenerExtension>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ConsolePlugin.getUniqueIdentifier(), "consolePatternMatchListeners");
            IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                PatternMatchListenerExtension extension = new PatternMatchListenerExtension(config);
                this.fPatternMatchListeners.add(extension);
                ++n2;
            }
        }
        ArrayList<PatternMatchListener> list = new ArrayList<PatternMatchListener>();
        Iterator<PatternMatchListenerExtension> i = this.fPatternMatchListeners.iterator();
        while (i.hasNext()) {
            PatternMatchListenerExtension extension = i.next();
            try {
                if (extension.getEnablementExpression() == null) {
                    i.remove();
                    continue;
                }
                if (!(console instanceof TextConsole) || !extension.isEnabledFor(console)) continue;
                TextConsole textConsole = (TextConsole)console;
                PatternMatchListener patternMatchListener = new PatternMatchListener(extension);
                try {
                    textConsole.addPatternMatchListener(patternMatchListener);
                    list.add(patternMatchListener);
                }
                catch (PatternSyntaxException e) {
                    ConsolePlugin.log(e);
                    i.remove();
                }
            }
            catch (CoreException e) {
                ConsolePlugin.log(e);
            }
        }
        return list.toArray(new PatternMatchListener[0]);
    }

    public IConsolePageParticipant[] getPageParticipants(IConsole console) {
        if (this.fPageParticipants == null) {
            IConfigurationElement[] elements;
            this.fPageParticipants = new ArrayList<ConsolePageParticipantExtension>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ConsolePlugin.getUniqueIdentifier(), "consolePageParticipants");
            IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                ConsolePageParticipantExtension extension = new ConsolePageParticipantExtension(config);
                this.fPageParticipants.add(extension);
                ++n2;
            }
        }
        ArrayList<IConsolePageParticipant> list = new ArrayList<IConsolePageParticipant>();
        for (ConsolePageParticipantExtension extension : this.fPageParticipants) {
            try {
                if (!extension.isEnabledFor(console)) continue;
                list.add(extension.createDelegate());
            }
            catch (CoreException e) {
                ConsolePlugin.log(e);
            }
        }
        return list.toArray(new IConsolePageParticipant[0]);
    }

    public ConsoleFactoryExtension[] getConsoleFactoryExtensions() {
        if (this.fConsoleFactoryExtensions == null) {
            IConfigurationElement[] configurationElements;
            this.fConsoleFactoryExtensions = new ArrayList<ConsoleFactoryExtension>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ConsolePlugin.getUniqueIdentifier(), "consoleFactories");
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                this.fConsoleFactoryExtensions.add(new ConsoleFactoryExtension(configurationElement));
                ++n2;
            }
        }
        return this.fConsoleFactoryExtensions.toArray(new ConsoleFactoryExtension[0]);
    }

    @Override
    public void refresh(IConsole console) {
        this.fRepaintJob.addConsole(console);
        this.fRepaintJob.schedule(50L);
    }

    class ConsoleNotifier
    implements ISafeRunnable {
        private IConsoleListener fListener;
        private int fType;
        private IConsole[] fChanged;

        ConsoleNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, ConsolePlugin.getUniqueIdentifier(), 120, ConsoleMessages.ConsoleManager_0, exception);
            ConsolePlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 1: {
                    this.fListener.consolesAdded(this.fChanged);
                    break;
                }
                case 2: {
                    this.fListener.consolesRemoved(this.fChanged);
                    break;
                }
            }
        }

        public void notify(IConsole[] consoles, int update) {
            this.fChanged = consoles;
            this.fType = update;
            Iterator iterator = ConsoleManager.this.fListeners.iterator();
            while (iterator.hasNext()) {
                IConsoleListener iConsoleListener;
                this.fListener = iConsoleListener = (IConsoleListener)iterator.next();
                SafeRunner.run((ISafeRunnable)this);
            }
            this.fChanged = null;
            this.fListener = null;
        }
    }

    private class RepaintJob
    extends WorkbenchJob {
        private final Set<IConsole> list;

        public RepaintJob() {
            super("schedule redraw() of viewers");
            this.list = new HashSet<IConsole>();
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addConsole(IConsole console) {
            Set<IConsole> set = this.list;
            synchronized (set) {
                this.list.add(console);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            Set<IConsole> set = this.list;
            synchronized (set) {
                IWorkbenchWindow[] workbenchWindows;
                if (this.list.isEmpty()) {
                    return Status.OK_STATUS;
                }
                IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = workbenchWindows.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control;
                    ConsoleView view;
                    IViewPart part;
                    IWorkbenchPage page;
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    if (window != null && (page = window.getActivePage()) != null && (part = page.findView("org.eclipse.ui.console.ConsoleView")) != null && part instanceof IConsoleView && this.list.contains((view = (ConsoleView)part).getConsole()) && !(control = view.getCurrentPage().getControl()).isDisposed()) {
                        control.redraw();
                    }
                    ++n2;
                }
                this.list.clear();
            }
            return Status.OK_STATUS;
        }
    }

    private class ShowConsoleViewJob
    extends WorkbenchJob {
        private final Set<IConsole> queue;

        ShowConsoleViewJob() {
            super("Show Console View");
            this.queue = new LinkedHashSet<IConsole>();
            this.setSystem(true);
            this.setPriority(20);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addConsole(IConsole console) {
            Set<IConsole> set = this.queue;
            synchronized (set) {
                this.queue.add(console);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            LinkedHashSet<IConsole> consolesToShow;
            Set<IConsole> set = this.queue;
            synchronized (set) {
                consolesToShow = new LinkedHashSet<IConsole>(this.queue);
                this.queue.clear();
            }
            for (IConsole c : consolesToShow) {
                this.showConsole(c);
            }
            set = this.queue;
            synchronized (set) {
                if (!this.queue.isEmpty()) {
                    this.schedule();
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void showConsole(IConsole c) {
            IWorkbenchPage page;
            boolean consoleFound = false;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && c != null && (page = window.getActivePage()) != null) {
                List<IConsoleView> list = ConsoleManager.this.fConsoleViews;
                synchronized (list) {
                    for (IConsoleView consoleView : ConsoleManager.this.fConsoleViews) {
                        boolean consoleVisible;
                        if (!consoleView.getSite().getPage().equals(page) || !(consoleVisible = page.isPartVisible((IWorkbenchPart)consoleView))) continue;
                        consoleFound = true;
                        boolean bringToTop = ConsoleManager.this.shouldBringToTop(c, consoleView);
                        if (bringToTop) {
                            page.bringToTop((IWorkbenchPart)consoleView);
                        }
                        consoleView.display(c);
                    }
                }
                if (!consoleFound) {
                    try {
                        IConsoleView consoleView = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView", null, 3);
                        boolean bringToTop = ConsoleManager.this.shouldBringToTop(c, consoleView);
                        if (bringToTop) {
                            page.bringToTop((IWorkbenchPart)consoleView);
                        }
                        consoleView.display(c);
                    }
                    catch (PartInitException pie) {
                        ConsolePlugin.log(pie);
                    }
                }
            }
        }
    }
}

