/*
 * Copyright (c) 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "LICENSE"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
 * CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE
 * PERFORMANCE, SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT
 * NAVIGATION OR COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE
 * SUPPORT MACHINES, OR WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE
 * SOFTWARE COULD LEAD DIRECTLY TO DEATH, PERSONAL INJURY, OR SEVERE
 * PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH RISK ACTIVITIES").  SUN
 * SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTY OF FITNESS FOR
 * HIGH RISK ACTIVITIES.
 */

package java.sql;

/**
 * <P>The SQLException class provides information on a database access
 * error.
 *
 * <P>Each SQLException provides several kinds of information: 
 * <UL>
 *   <LI> a string describing the error.  This is used as the Java Exception
 *       message, and is available via the getMesage() method
 *   <LI> A "SQLstate" string which follows the XOPEN SQLstate conventions.
 *       The values of the SQLState string as described in the XOPEN SQL spec.
 *   <LI> An integer error code that is vendor specific.  Normally this will
 *	 be the actual error code returned by the underlying database.
 *   <LI> A chain to a next Exception.  This can be used to provided additional
 * 	 error information.
 * </UL>
 */
public class SQLException extends java.lang.Exception {

    /**
     * Construct a fully specified SQLException  
     *
     * @param reason a description of the exception 
     * @param SQLState an XOPEN code identifying the exception
     * @param vendorCode a database vendor specific exception code
     */
    public SQLException(String reason, String SQLState, int vendorCode) {
	super(reason);
	this.SQLState = SQLState;
	this.vendorCode = vendorCode;
	DriverManager.println("SQLException: reason(" + reason + 
			      ") SQLState(" + SQLState + 
			      ") vendor code(" + vendorCode + ")");
    }


    /**
     * Construct an SQLException without a vendorCode
     *
     * @param reason a description of the exception 
     * @param SQLState an XOPEN code identifying the exception
     */
    public SQLException(String reason, String SQLState) {
	super(reason);
	this.SQLState = SQLState;
	this.vendorCode = 0;
	DriverManager.println("SQLException: reason(" + reason + 
			      ") SQLState(" + SQLState + ")");
    }

    /**
     * Construct an SQLException with only a reason
     *
     * @param reason a description of the exception 
     */
    public SQLException(String reason) {
	super(reason);
	this.SQLState = "";
	this.vendorCode = 0;
	DriverManager.println("SQLException: reason(" + reason + ")");
    }

    /**
     * Construct an SQLException with no description
     *
     */
    public SQLException() {
	super();
	this.SQLState = "";
	this.vendorCode = 0;
	DriverManager.println("SQLException: ");
    }

    /**
     * Get the SQLState
     *
     * @return the SQLException's SQLState value
     */
    public String getSQLState() {
	return (SQLState);
    }	

    /**
     * Get the vendor specific exception code
     *
     * @return the SQLException's vendorCode value
     */
    public int getErrorCode() {
	return (vendorCode);
    }

    /**
     * Get the exception chained to this one. 
     *
     * @return the next SQLException in the chain
     */
    public SQLException getNextException() {
	return (next);
    }

    /**
     * Add an SQLException to the end of the chain.
     *
     * @param ex the new end of the SQLException chain
     */
    public synchronized void setNextException(SQLException ex) {
	SQLException theEnd = this;
	while (theEnd.next != null) {
	    theEnd = theEnd.next;
	}
	theEnd.next = ex;
    }

    private String SQLState;
    private int vendorCode;
    private SQLException next;
}
