
/* qddb/Lib/LibQsql/SqlRel.c -- just a stub for now
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include <stdlib.h>
#include "Qddb.h"
#define JDBC
int LoadBuffer (Constant[], Identifier[], ClistNode[], Schema *,
						unsigned int, unsigned int, char *);
int FindIndex(	Constant[], Identifier[], ClistNode[], unsigned int,
				unsigned int, unsigned int);
int CheckTableName(Schema *, char *);
void DetermineSelectColumns(Constant[],Identifier[],ClistNode[],
						OpStack[],OpStackList[],TabExp[],unsigned int,
						char **, size_t *, char **, size_t *,Schema *);
void DetermineWhereColumns(Constant[],Identifier[],ClistNode[],
						OpStack[],OpStackList[],TabExp[],unsigned int,
						char **, size_t *, char **, size_t *,
						unsigned int *,	Constant *,unsigned int *, unsigned int);
int WhereExpressions(Constant[],Identifier[],ClistNode[],
						OpStack[],OpStackList[],TabExp[],unsigned int,
						char **, size_t *, char **, size_t *,
						unsigned int *,	Constant *,unsigned int *,
						unsigned int, q_cols *, q_data *);
char* strsep _ANSI_ARGS_((char **pp, const char *delim))
{
	char *result, *temp;
	int reachedEnd = 0;
	
	if (! (result = *pp))
		return NULL;
	temp = *pp;
	while ( (*temp != *delim) && (*temp != '\0') )
		temp = temp + 1;
	if (*temp == '\0')
	{
		reachedEnd = 1;
	}
	if (reachedEnd == 0)
	{
		*pp = temp + 1;
		*temp = '\0';
	}
	else
		*pp = NULL;
	return result;

}

void Qddb_Init _ANSI_ARGS_((void))
{

}

SqlReturn ResetRelationList()
{
}


SqlReturn AddToRelationList(PathName, Name)
    char		*PathName, *Name;
{
}


SqlReturn FindRelationByName(Name)
    char		*Name;
{
}


SqlReturn AddAliasToRelation(Name, Alias)
    char		*Name, *Alias;
{
}

Schema *SQLConnect(Name)
	char	*Name;
{
    char	Relation[MAXFILENAMELEN];
    char	*rel;
	Schema 	*db;

    //Qddb_Init();

    if ((rel = Qddb_FindRelation(Name)) == NULL) {
   	   fprintf(stderr, "Cannot find relation %s",Relation);
	   exit(1);
    }

    strcpy(Name, rel);
    db = Qddb_InitSchema(Name);
    if (db == NULL) {
		if (qddb_errmsg != NULL) {
		    fprintf(stderr, "%s", qddb_errmsg);
		} else {
	    	fprintf(stderr, "Unknown error '%d' while reading schema\n", qddb_errno);
		}
		fflush(stderr);
		exit(1);
    }

	return(db);
}

void* SQLQuery(schema, SQLStmt, err)
	Schema	*schema;
	char	*SQLStmt;
	int     *err;
{
	int		SqlCode;
	int SqlParseRet;
	char	SqlState[5];
	char *AttrName;
	KeyList *keyList, *tempList, SplitList;
	Result *result;

	//printf("In SQLQuery\n");	
	Qddb_ResetSqlParser();  
    	Qddb_SqlParse_Set(schema);
	Qddb_SetBuffer(SQLStmt);
	SqlParseRet = SqlParse();
	 //printf("GEtting result\n");
    	if (SqlParseRet == 0){
    		result = (Result *) Qddb_SqlParse_Get(&SqlCode,&SqlState);
		*err = 0;
		//printf(" SqlParseRet == 0\n");
		//SQLListTable(result);
		return(result);
    	}
	//printf(" SqlParseRet != 0\n");
	*err = -1;
    	return NULL;
}

void *RemoveDuplicateRows(KeyList *keylist)
{
	KeyList *dummyList, *Head;
	size_t Number;
	int i = 0;
	
	Head = keylist;        
	while (keylist != NULL)
	{
		Number = keylist->Number;
		dummyList = keylist;
		while ( (keylist->next != NULL)&&(Number == keylist->next->Number))
		{
			keylist = keylist->next;
		}
		if (keylist->next != NULL)
			dummyList->next = keylist->next;
		keylist = keylist->next;     	
	}
	dummyList->next = NULL;
	return Head;
}

void SQLListColumns(Result *result)
{
	q_cols	*colnmes;
	if (result->colslist != NULL) {
		colnmes = result->colslist;
		do {
			printf("%s, ",colnmes->cols.name);
			colnmes = colnmes->next;
		} while (colnmes != NULL);
		printf("\n");
	}
}

void SQLListTable(Result *result)
{
	q_data	*colvals;
	int i,j;
	if (result->datalist != NULL) {
		colvals = result->datalist;
		j = 0;
		do {
			if (colvals->data != NULL) {
				for (i=0;i<result->numcolumns;i++) {
					if (colvals->data[i] != NULL)
					printf("%s : ",colvals->data[i]);
				}
				printf("\n");
			}
			colvals = colvals->next;
			j++;
		} while (colvals != NULL);
	}

}
void SQLFreeTable(Result *result)
{
	q_cols	*colnmes,*tempcol;
	q_data	*colvals,*tempval;
	if (result->colslist != NULL) {
		colnmes = result->colslist;
		do {
			Free(colnmes->cols.name);
			tempcol = colnmes->next;
			Free(colnmes);
			colnmes = tempcol;
		} while (colnmes != NULL);
		result->colslist = NULL;
	}
	if (result->datalist != NULL) {
		colvals = result->datalist;
		do {
			tempval = colvals->next;
			SQLFreeRow (colvals, result->numcolumns);
			colvals = tempval;
		} while (colvals != NULL);
		result->datalist = NULL;
	}
}
void SQLFreeRow(q_data *datalist, int numcolumns)
{
	int i;
	if (datalist != NULL)
		if (datalist->data != NULL)
			for (i=0;i<numcolumns;i++) 
				Free(datalist->data[i]);
}

SqlReturn InsertTable(	Schema		*schema,
						Constant	Constants[],
						Identifier	Identifiers[],
						ClistNode	Clists[],
						OpStack		Ops[],
						OpStackList	OpstackLists[],
						TabExp		TbExps[],
						unsigned int TableIndex,
						unsigned int ColumnListHead,
						unsigned int ValueListHead)
{
    InCoreEntry	*CurrentEntry;
    Entry		ThisEntry = NULL;
	char		*buf;									 
	if (!(CheckTableName(schema,Identifiers[TableIndex].TableName))) {
	   printf("Invalid Table Name : %s",Identifiers[TableIndex].TableName);
	   return;
	}

    buf = Malloc(BUFSIZ);
	buf = "";
	LoadBuffer(Constants, Identifiers, Clists, schema,
						ColumnListHead, ValueListHead, buf);

	if ((CurrentEntry = (InCoreEntry *)Qddb_Convert(schema,QDDB_ENTRYTYPE_READABLE, buf,
					 QDDB_ENTRYTYPE_INTERNAL)) == NULL) {
	    Free(buf);
	    return;
	}
	Qddb_SortInCoreEntries(schema, CurrentEntry);
	if ((ThisEntry = (Entry)Qddb_Convert(schema, QDDB_ENTRYTYPE_INTERNAL, CurrentEntry, 
					     QDDB_ENTRYTYPE_EXTERNAL)) == NULL) {
	}
	if (Qddb_AddEntry(schema, NULL, False, ThisEntry) == -1) {
	    fprintf(stderr, "Could not obtain lock for addition.\n\
You may be running over NFS without a lockd.\n");
	}

}



SqlReturn InsertTuple(	Schema		*schema,
			Constant	Constants[],
			Identifier	Identifiers[],
			ClistNode	Clists[],
			OpStack		Ops[],
			OpStackList	OpstackLists[],
			TabExp		TbExps[],
			unsigned int AttrListHead,
			unsigned int ValueListHead)
{
}

void * SelectRows(	Schema		*schema,
			Constant	Constants[],
			Identifier	Identifiers[],
			ClistNode	Clists[],
			OpStack		Ops[],
			OpStackList	OpStackLists[],
			TabExp		TabExps[],
			int		DeleteDuplicates)
{

    size_t         *AttrWidth, AttrTop = 0, AttrsUsedTop = 0, AUsedTop = 0;
    unsigned int   *RelOp, *LogOp;
    char           **AttrName, **AttrsUsed, **AUsed; 
    Constant  	   *ValUsed;
    KeyList   	   *list, *list1, *keyList, *SplitList, *LastList = NULL;
    char	   *SepString = ":";
    unsigned int   i,j;
    size_t	   n;
    Boolean	   OnceThrough;
    Boolean	   SkipRow;
    int		   k=20;
    KeyList        *tempList, *tmplist = NULL;
    Qddb_SearchArg search_args;
    Qddb_PruneArgs args;
    Schema *dummySchema;
    Result         *result;
    q_cols	   *currcol;
    q_data         *currrow, *prevrow;
    char *relation, *dbname = "library";


    AttrName  = (char **)Malloc( k * sizeof(char *) );
    AttrsUsed = (char **)Malloc(k * sizeof(char *) );
    AttrWidth = (size_t *)Malloc(k * sizeof(size_t) );
    RelOp     = (unsigned int *)Malloc(k * sizeof(unsigned int) );
    ValUsed   = (Constant *)Malloc(k * sizeof(Constant) );
    LogOp     = (unsigned int *)Malloc(k * sizeof(unsigned int) );
    AUsed	  = (char **)Malloc(k * sizeof(char *) );

    //printf("In SelectRows\n");
    DetermineSelectColumns(Constants,Identifiers,Clists,
			   Ops,OpStackLists,TabExps,0,
			   AttrName,&AttrTop,AttrsUsed,&AttrsUsedTop, schema);
    for (i=0;i<AttrTop;i++)
    		//printf("Selection = %s\n",AttrName[i]);
    for (i=0;i<=AttrTop;i++)
		AttrWidth[i] = 0;
    LastList = NULL;
    tempList = NULL;

    if (TabExps[0].Where == NIL) {							search_args.UpperExists = 0;
	search_args.LowerExists = 0;
	search_args.Type = ALPHARANGE;
	keyList = Qddb_Search(schema, &search_args, &n, -1);
	//if (keyList == NULL)
		//printf("keyList = NULL\n");
	args.attrs = AttrName;
	args.attr_len = AttrTop;
	//tempList = RemoveDuplicateRows(keyList);
	LastList = Qddb_KeyListProcess(schema, keyList, &args, 
			QDDB_KEYLIST_PROC_PRUNE, QDDB_KEYLIST_FLAG_PRUNEBYROW); 
	//if (LastList == NULL)
		//printf("LastList = NULL\n");
	//PrintKeyList(schema, LastList);
	//fprintf(stderr, "AttrTop in SelectRows = %d\n", AttrTop);
    	result = (Result *)Qddb_RowListQuery(schema, LastList, SepString, 
                                       AttrName, AttrWidth, 
	    	  		       (size_t)AttrTop, AttrsUsed, 
				       (size_t)AttrsUsedTop, True, True);
	Qddb_Free(QDDB_TYPE_KEYLIST, LastList); 
	//fprintf(stderr, "Got result and returning \n");
	return result;
    }
    else {
       //fprintf(stderr,"WHERE NOT NIL\n");
       DetermineWhereColumns(Constants,Identifiers,Clists,
			     Ops,OpStackLists,TabExps,0,
			     AttrName,&AttrTop,AttrsUsed,&AttrsUsedTop,
			     RelOp, ValUsed, LogOp, TabExps[0].Where);
       OnceThrough = False;
       for (i=0;i < AttrsUsedTop;i++) {
	  //fprintf(stderr, "i = %d\n",i);
	  list = NULL;
	  list1 = NULL;
	  if (AttrsUsedTop == NIL) {
	     //printf("AttrsUsedTop = NIL\n");
	     search_args.UpperExists = 0;
	     search_args.LowerExists = 0;
	     search_args.Type = ALPHARANGE;
	     tmplist = Qddb_Search(schema, &search_args, &n, -1);
	     //fprintf(stderr, "Qddb searched based on condition\n");
	     AttrsUsedTop = AttrTop;
	     for (j=0;j<AttrTop;j++) {
	        AttrsUsed[j] = (char *) Malloc(strlen(AttrName[j]) + 1);
		strcpy(AttrsUsed[j], AttrName[j]);
	     }
	     break;
	  }
	  if (Qddb_ConvertAttributeNameToNumber(schema, AttrsUsed[i]) < 0) {
	     fprintf(stderr, "Attribute %s doesn't exist\n", AttrsUsed[i]);
	     fflush(stderr);
	     exit(1);
	  }
          if ( (RelOp[i] == EQUAL) || (RelOp[i] == GREATERTHAN) ||
	       (RelOp[i] == LESSTHAN) || (RelOp[i] == NOTEQUAL) ){
	     switch (ValUsed[i].Type) {
		case STRINGCONS:
		   //fprintf(stderr,"Strings to be compared\n");
		   search_args.Alpha = (char*)Malloc(sizeof(char*)*strlen(ValUsed[i].Val.String));
	    	   strcpy(search_args.Alpha, ValUsed[i].Val.String);
		   search_args.Type  = ALPHA;
		   break;
		case INTEGERCONS:
	    	   search_args.Number = ValUsed[i].Val.Integer;
		   search_args.Type  = NUMERIC;
		   break;
		case REALCONS:
	    	   search_args.Number = ValUsed[i].Val.Real;
		   search_args.Type  = NUMERIC;
		   break;
	  }
	  //fprintf(stderr, "To search based on condition\n");
	  list = Qddb_Search(schema, &search_args, &n, -1);
	  //fprintf(stderr, "n = %d", n);
	  //fprintf(stderr, "To search based on condition\n");
	  list = (KeyList *)Qddb_KeyListProcess(schema, list, AttrsUsed[i],
					QDDB_KEYLIST_PROC_PRUNE,
					QDDB_KEYLIST_FLAG_PRUNEBYATTR);
	  //fprintf(stderr, "To search based on condition\n");
      }   
      if ( (RelOp[i] == GREATERTHAN) || (RelOp[i] == GREATEREQUAL) ||
           (RelOp[i] == LESSTHAN)    || (RelOp[i] == LESSEQUAL)    || 
           (RelOp[i] == NOTEQUAL) ){
	 //fprintf(stderr, "RelOp is not EQUAL\n");
	 switch (RelOp[i]) {
	    case GREATERTHAN: 
	       search_args.UpperExists = 0;
	       search_args.LowerExists = 1;
	       break;
	    case GREATEREQUAL: 
	       search_args.UpperExists = 0;
	       search_args.LowerExists = 1;
	       break;
	    case LESSTHAN: 
	       search_args.UpperExists = 1;
	       search_args.LowerExists = 0;
	       break;
	    case LESSEQUAL: 
	       search_args.UpperExists = 1;
	       search_args.LowerExists = 0;
	       break;
	    case NOTEQUAL:
	       search_args.UpperExists = 0;
	       search_args.LowerExists = 0;
	       break;
	}
        switch (ValUsed[i].Type) {
           case STRINGCONS:
	      search_args.Type  = ALPHARANGE;
	      if (search_args.UpperExists)
	         search_args.UpperStr = ValUsed[i].Val.String;
	      else
	         if (search_args.LowerExists) 
                    search_args.LowerStr = ValUsed[i].Val.String;
              else
	    	 search_args.Alpha = ValUsed[i].Val.String;
	      break;
	   case INTEGERCONS:
	      search_args.Type  = NUMERICRANGE;
	      if (search_args.UpperExists)
	         search_args.UpperNum = ValUsed[i].Val.Integer;
	      else
	         if (search_args.LowerExists)
		    search_args.LowerNum = ValUsed[i].Val.Integer;
	      else
		    search_args.Number = ValUsed[i].Val.Integer;
	      break;
	   case REALCONS:
	      search_args.Type  = NUMERICRANGE;
	      if (search_args.UpperExists)
	         search_args.UpperNum = ValUsed[i].Val.Real;
	      else
		 if (search_args.LowerExists)
		 search_args.LowerNum = ValUsed[i].Val.Real;
	      else
	         search_args.Number = ValUsed[i].Val.Real;
	      break;
	}
	list1 = Qddb_Search(schema, &search_args, &n, -1);
	list1 = (KeyList *)Qddb_KeyListProcess(schema, list1, AttrsUsed[i],
					       QDDB_KEYLIST_PROC_PRUNE,
					       QDDB_KEYLIST_FLAG_PRUNEBYATTR);
        if ( (RelOp[i] == GREATEREQUAL) || (RelOp[i] == LESSEQUAL) )
	   list = list1;
	else
	   list = Qddb_KeyListOp(schema, list1, list, 
				 QDDB_KEYLIST_OP_EXCLUSION, 0);
      }

	if (RelOp[i] == LIK) {
	   //fprintf(stderr, "RelOp is LIK\n");
	   search_args.Alpha = ValUsed[i].Val.String;
	   search_args.Type  = REGEXP_V8;
	   list = Qddb_Search(schema, &search_args, &n, -1);
	   list = (KeyList *)Qddb_KeyListProcess(schema, list, AttrsUsed[i],
					       QDDB_KEYLIST_PROC_PRUNE,
					       QDDB_KEYLIST_FLAG_PRUNEBYATTR);
	}
 
        if (tmplist == NULL && OnceThrough == False) {
	   //printf("tmplist is NULL\n");
	   tmplist = list;
	   OnceThrough = True;
	} 
        else {
	   //printf("tmplist is NOTNULL\n");
	   if (LogOp[i] == INTERSECTIONOP)
	      tmplist = Qddb_KeyListOp(schema, tmplist, list, 
				       QDDB_KEYLIST_OP_INTERSECTION, 0);
	   else
	      tmplist = Qddb_KeyListOp(schema, list, tmplist, 
				       QDDB_KEYLIST_OP_UNION, 0);
	}
      }
      if (LastList == NULL) {
	 LastList = tmplist;
      } 
      else {
	 LastList = Qddb_KeyListOp(schema, tmplist, LastList, 
				   QDDB_KEYLIST_OP_INTERSECTION, 0);
      }
      //return LastList;
/* This was commented */
      if (AttrsUsedTop > 0) {
	 Qddb_PruneArgs		prune_args;
	 prune_args.attrs = AttrsUsed;
	 prune_args.attr_len = AttrsUsedTop;
	 LastList = (KeyList *)Qddb_KeyListProcess(schema, LastList, 
						   &prune_args, 
						   QDDB_KEYLIST_PROC_PRUNE,
						QDDB_KEYLIST_FLAG_PRUNEBYROW);
      }

      for (i=0;i<AttrsUsedTop;i++) {
	 for (j=0;j<AUsedTop;j++) {
	    if (AttrsUsed[i] == AUsed[j])
	       break;
	 }
         if (j == AUsedTop)
	    AUsed[AUsedTop++] = AttrsUsed[i];
      }
      result = (Result *)Qddb_RowListQuery(schema, LastList, SepString, 
                                           AttrName, AttrWidth, 
	    	  (size_t)AttrTop, AUsed, (size_t)AUsedTop, False, True);

/*  Expression Evaluation */
      if (result->colslist != NULL) {
	 currcol = result->colslist;
	 while (currcol->next != NULL) {
	    //printf("%s, ",currcol->cols.name);
	    currcol = currcol->next;
	 }
      }

      if (result->datalist != NULL) {
	 prevrow = NULL;
	 currrow = result->datalist;
            do {
	       SkipRow = False;
	       if (currrow->data != NULL) {
//                for (i=0;i<result->numcolumns;i++) {
//	             //printf("%s : ",currrow->data[i]);
//                }
/*
                  SkipRow = WhereExpressions(Constants,Identifiers,
				 Clists,Ops,OpStackLists,TabExps,0,
				 AttrName,&AttrTop,AttrsUsed,&AttrsUsedTop,
				 RelOp, ValUsed, LogOp, TabExps[0].Where,
				 currcol,currrow);
*/
               }
               if (SkipRow) {
            	  prevrow->next = currrow->next;
//	          Free(*currrow);
	    	  SQLFreeRow (currrow, result->numcolumns);
	    	  currrow = currrow->next;
               }
               else  {
            	  prevrow = currrow;
	    	  currrow = currrow->next;
               }
            } while (currrow != NULL);
	}   
      }
      for (i=0;i<AttrTop;i++) {
	 Free(AttrName[i]);
	 AttrName[i] = NULL;
      }
      for (i=0;i<AttrsUsedTop;i++) {
		Free(AttrsUsed[i]);
		AttrsUsed[i] = NULL;
	}
/*
	Free(AUsed);
	Free(AttrName);
	Free(AttrsUsed);
	Free(ValUsed);
*/
	Free(AttrWidth);
	Free(RelOp);
	Free(LogOp);

	return (result);
	//return LastList;
}

/*void *PruneListByAttributes(schema, list, Attrs, AttrTop)
	KeyList *list;
	char **Attrs;
	int AttrTop;
{
	int i, startCount, lengthCount, tempAttr, PruneAttribute = 0;
	char *AttrName, *AttrNameNext;
	size_t *AttrNum;
	KeyList *kl, *tempList, *retval, *dummyList;
	
	retval = tempList = list;
	while(tempList != NULL)
	{
	   if (Qddb_ReadEntryByKeyList(DBFile, RelationFN, &ThisEntry, list,
	       True) != -1) {
	       row = 0; 
	       while (ThisEntry[row][col] != NULL)
	       {
		   col = 0;
		   while ( (ThisEntry[row][col] != '=') || 
				(ThisEntry[row][col] != ' '))
		      AttrName[col] = ThisEntry[row][col++];
		   for (i=0; i++; i< AttrTop)
		       cmp = strcmp(AttrName, Attrs[i]); 
	 	   if (cmp == 0)
		   {
		       if (LastAttributeIncluded == 1)
			    length = length + strlen(ThisEntry[row]);
	  
		       else
		       {
			    retval->next = malloc(sizeof(KeyList*));
			    retval->next->Start = retval->Start + 
							PrunedEntriesLength;
			    retval->next->Attribute = retval->Attribute;
			    retval->next->Number = retval->Number;
			    strcpy(retval->next->Instance, retval->Instance);
			    retval = retval->next;
			}
			LastAttributeIncluded = 1;
		    }
			    
	       }      
              

	fprintf(stderr, "In PruneList..\n");
	tempList = NULL;
	kl = retval = list;
	while (kl != NULL)
	{
		AttrName = Qddb_ConvertAttributeNumberToName(schema, kl->Attribute);
		PruneAttribute = 1;
		for (i=0;i++;i<AttrTop)
		{
			cmp = strcmp(AttrName, Attrs[i]);
			fprintf(stderr, "cmp = %d\n", cmp);
			if (cmp == 0) 
			{
				PruneAttribute = 0;
				fprintf(stderr, "cmp = %d\n", cmp);
				fprintf(stderr, "i = %d and PA is 0\n", i);
				break;
			}
			else 
				fprintf(stderr, "cmp =  %d\n", cmp); 
		}         
		if (PruneAttribute == 1)
		{
			fprintf(stderr, "PruneAttribute is 1\n");
			fprintf(stderr, "AttrName from kl = %s\n",AttrName);
			if (tempList == NULL)
			{
				retval = kl->next;
				Free(kl->Instance);
				Free(kl);
				kl = retval;
			}
			else {
				tempList->next = kl->next;
				Free(kl->Instance);
				Free(kl);
				kl = tempList->next;
			}
		}
		else {
			fprintf(stderr, "AttrName from kl = %s\n",AttrName);
			tempList = kl;
			kl = kl->next;
		}
	}			
	if (retval == NULL)
		printf("retval is NULL\n");
	else
		printf("retval is not NULL\n");
	PrintKeyList(schema, retval);
	fprintf(stderr, "Returning from pruneLsit\n");
	Free(AttrNum);
	return retval;
	return list;
}*/

void PrintKeyList(schema, list)
	Schema  *schema;
	KeyList *list;
{
	Entry ThisEntry = NULL;
	char *out;
	char *AttrName;
	int DBFile;

	fprintf(stderr, "In PrintKeyList \n");
	DBFile = OpenDatabase(schema->RelationName, 0);
	while (list != NULL) {
	AttrName = Qddb_ConvertAttributeNumberToName(schema, list->Attribute);
	fprintf(stderr, "AttrName for list = %s\n", AttrName);
	if (Qddb_ReadEntryByKeyList(DBFile, schema->RelationName, &ThisEntry,
					list, True) == -1) {
		list = list->next;
		continue;
	}
	Qddb_ReducedAttrToFullAttr(schema, ThisEntry);
	out = (char *) Qddb_Convert(schema, QDDB_ENTRYTYPE_EXTERNAL, ThisEntry,
			QDDB_ENTRYTYPE_EXTERNAL);
	printf("%s\n", out);
	list = list->next;
	}
	close(DBFile);
}


int CheckTableName (schema, Table)
	Schema	*schema;
	char	*Table;
{
	unsigned int Level,node;
	unsigned int i,k;
	char *temp1;
	char *temp2 = NULL, *schemaname = NULL;
	char **attr;
	Level = 1;
	temp1 = (char *)Malloc(strlen(schema->RelationName) + 1);
	strcpy (temp1,schema->RelationName);

	temp2 = strsep(&temp1, "/\\");
	while (temp2 != NULL) {
		schemaname = temp2;
		temp2 = strsep(&temp1, "/\\");
	}
	if (strcmp(schemaname,Table) == 0)
		return 1;
	
	temp1 = Realloc(temp1,strlen(Table) + 1);	
	strcpy (temp1,Table);
	node = 0;
	do {
		attr[node] = strsep(&temp1, ".");
	} while (attr[node++] != NULL);

	Free(temp1);

	i=0;
	k=1;
	node = 0;
	do {
    	for (i = k; i <= schema->NumberOfAttributes; i++) {
			if (schema->Entries[i].IsLeaf != True) {
				if (strcmp(attr[node],schema->Entries[i].Name) == 0) {
					k = i;
					break;
				}
			}
		}
	} while ( (attr[++node] != NULL) && (i <= schema->NumberOfAttributes) );

	if (i <= schema->NumberOfAttributes)
		return 1;
	else
		return -1;
}

int LoadBuffer(	Constants, Identifiers, Clists, MySchema,
						ColumnListHead, ValueListHead, buf)
	Constant	Constants[];
	Identifier	Identifiers[];
	ClistNode	Clists[];
    Schema		*MySchema;
	unsigned int ColumnListHead;
	unsigned int ValueListHead;
	char		*buf;
{
    Schema		*csp = MySchema;
    unsigned int	i,j,k,l,Level;
	int				buflen, namlen, vallen;
	int				bufsiz = BUFSIZ;
	int				bufsize = BUFSIZ;
	char			*numstring;
    numstring = Malloc(50);
    strcat(buf, "$NUMBER$ = \"1\";\n");
	buflen = 15;
    Level = 1;
								  
	j = ValueListHead;

    for (i = 1; i <= csp->NumberOfAttributes; i++) {
	if (csp->Entries[i].IsLeaf == True) {
		namlen = strlen(csp->Entries[i].Name);

		if (ColumnListHead == NIL)
			k = Clists[j].Index;
		else {
			l = FindIndex(	Constants, Identifiers, Clists,
							ColumnListHead,	ValueListHead, i);
			if (l == NIL)
				k = NIL;
			else
				k = Clists[l].Index;
		}

		if (k == NIL)
			vallen = 0;
		else {
			switch (Constants[k].Type) {
				case STRINGCONS: 
					vallen = strlen(Constants[k].Val.String);
					break;
				case INTEGERCONS:
					//itoa(Constants[k].Val.Integer,numstring,10);
					sprintf(numstring,"%d",Constants[k].Val.Integer);
					vallen = strlen(numstring);
					break;
				case REALCONS: 
					gcvt(Constants[k].Val.Real,20,numstring);
					vallen = strlen(numstring);
					break;
				default:
					break;
			}
		}


		if (bufsize - namlen - vallen - 100 <= buflen)
	       buf = Realloc(buf, (size_t)(bufsiz += BUFSIZ));
    
	    strcat(buf, csp->Entries[i].Name);
	    strcat(buf, " = \"");
		if (k != NIL) {
			switch (Constants[k].Type) {
				case STRINGCONS: 
					strcat(buf, Constants[k].Val.String);
					break;
				case INTEGERCONS: 
					strcat(buf, numstring);
					break;
				case REALCONS: 
					strcat(buf, numstring);
					break;
				default:
					break;
			}
		}
	    strcat(buf, "\"\n");
	    buflen = buflen + namlen + vallen + 6;
		if (Clists[j].Next != NIL)
			j = Clists[j].Next;
	} else {

		namlen = strlen(csp->Entries[i].Name);

		if (bufsize - namlen - 100 <= buflen)
	       buf = Realloc(buf, (size_t)(bufsiz += BUFSIZ));
    
	    strcat(buf, csp->Entries[i].Name);
	    strcat(buf, " (\n");
	    buflen = buflen + namlen + 3;
	}
	if (i == csp->NumberOfAttributes)
	    continue;
	if (csp->Entries[i+1].Level > Level)
	    Level++;
	else if (csp->Entries[i+1].Level < Level) {
	    while (csp->Entries[i+1].Level < Level) {
		Level--;
	    strcat(buf, "\n");
	    buflen = buflen + 1;
	    }
	}
    }
    while (Level-- > 1) {
	    strcat(buf, ")\n");
	    buflen = buflen + 2;
	}
	Free(numstring);
    return 0;
}

int FindIndex(	Constants, Identifiers, Clists,	ColumnListHead,
				ValueListHead, AttrNumber)
	Constant	Constants[];
	Identifier	Identifiers[];
	ClistNode	Clists[];
	unsigned int ColumnListHead;
	unsigned int ValueListHead;
	unsigned int AttrNumber;
{
    unsigned int	i,j;	   
	i = ColumnListHead;
	j = ValueListHead;
    do {
		if (Identifiers[Clists[i].Index].Column == AttrNumber)
			return j;          //Clists[i].Index;
		i = Clists[i].Next;
		j = Clists[j].Next;
    } while (Clists[i].Next != NIL);
	if (Identifiers[Clists[i].Index].Column == AttrNumber)
		return j;               //Clists[i].Index;
	else
		return NIL;
}

/*void DetermineSelectColumns (Constants,Identifiers,Clists,Ops,
			    OpStackLists,TabExps,index,
			    AttrName,AttrTop,AttrsUsed,AttrsUsedTop,
			    schema)*/
void DetermineSelectColumns	(Constants,Identifiers,Clists,Ops,OpStackLists,TabExps,
							index,AttrName,AttrTop,AttrsUsed,AttrsUsedTop,
							schema)
	Constant			Constants[];
	Identifier			Identifiers[];
	ClistNode			Clists[];
	OpStack				Ops[];
	OpStackList			OpStackLists[];
	TabExp				TabExps[];
    	unsigned int		index;
	char			*AttrName[];
	size_t			*AttrTop;
	char			*AttrsUsed[];
	size_t			*AttrsUsedTop;
	Schema			*schema;
{
    unsigned int	i,j,k,l,TabNum,top,bot;
    unsigned int	Colsize = 0, Valsize = 0;
    unsigned int	TableLevel = 0;
    unsigned int	TableAttrNumber = 0;
    int			AncestorNum;
    char		*AncestorName, Ancestor[1024];
    Ancestor[0] = '\0';

	//fprintf(stderr, "In DetermineSelectColumns\n");
	if (TabExps[index].Select == NIL) {	//select all columns
	        //fprintf(stderr, "Selest = NIL\n");
		i = TabExps[index].From;
    		while (i != NIL) {
		   	TabNum = Identifiers[Clists[i].Index].Column; 
			//fprintf(stderr, "TabNum = %d\n",TabNum);
			TableLevel = schema->Entries[TabNum].Level;
			//fprintf(stderr, "TabLevel = %u\n",TableLevel);
			//fprintf(stderr, "NumAttributes = %d\n",schema->NumberOfAttributes);
			for (j=TabNum;j<=schema->NumberOfAttributes;j++) {
				/*fprintf(stderr, "j = %d\n",j);
				fprintf(stderr, "TabNum = %d\n",TabNum);
				fprintf(stderr, "j->level = %d\n",schema->Entries[j].Level);
				fprintf(stderr, "j->Number = %d\n",schema->Entries[j].Number);
			if (j > 0)
				fprintf(stderr, "j->Name = %s\n",schema->Entries[j].Name);*/
				if ( (schema->Entries[j].Level == TableLevel) &&
				(j > TabNum) &&
				(Identifiers[Clists[i].Index].Column != 0) )
					break;
				if (schema->Entries[j].IsLeaf == False) {
					Ancestor[0] = '\0';
					for (k = 1;k<schema->Entries[j].Level;k++) {
				AncestorNum = FindAncestor 
                                           (schema, schema->Entries[j].AncestorNumber[k]					    , k, j);
				/*printf("AncetorNum = %d\n", AncestorNum);
				fprintf(stderr, "Ancestor Number = %d\n", schema->Entries[j].AncestorNumber[k]);
				fprintf(stderr, "Ancestor k's name = %s\n", schema->Entries[schema->Entries[j].AncestorNumber[k]].Name);
				fprintf(stderr, "k = %d\n",k);
				fprintf(stderr, "j = %d\n",j);
				fprintf(stderr, "Ancestor = %d\n",schema->Entries[j].AncestorNumber[k]);*/
				strcat(Ancestor,schema->Entries[AncestorNum].Name);
				/*strcat(Ancestor,schema->Entries
							[schema->Entries[j].AncestorNumber[k]].Name);*/
						strcat(Ancestor,".");
					//fprintf(stderr, "AttrName for Not a leaf = %s\n", Ancestor);
					}
				//fprintf(stderr,"Out of for loop\n");
					if (j > 0) { 
						/*fprintf(stderr, "j = %d is > 0\n", j);
				fprintf(stderr, "j->Name = %s\n",schema->Entries[j].Name);
				fprintf(stderr, "j->Number = %d\n",schema->Entries[j].Number);*/
						strcat(Ancestor,schema->Entries[j].Name);
						strcat(Ancestor,".");
					}
				}
				if (schema->Entries[j].IsLeaf == True) {
					//fprintf(stderr, "Is Leaf and Attrname = %s\n", schema->Entries[j].Name);
					if ( (schema->Entries[j]. Level) <
					     (schema->Entries[j-1].Level - 1))
					{
					    Ancestor[0] = '\0';
					    for (k = 1; k < schema->Entries[j].Level; k++)
					    {
						AncestorNum = FindAncestor 
                                                              (schema, 
							       schema->Entries[j].AncestorNumber[k], k, j);
						strcat(Ancestor, schema->Entries[AncestorNum].Name);
						strcat(Ancestor, ".");
					    }
					}
					l = strlen(Ancestor) + strlen(schema->Entries[j].Name) + 1;
					AttrName[(*AttrTop)++] = (char *) Malloc (l);
					//fprintf(stderr, "Ancestor = %s\n", Ancestor);
					strcpy(AttrName[*AttrTop - 1], Ancestor);
					//fprintf(stderr, "Ancestor = %s\n", AttrName[*AttrTop - 1]);
					strcat(AttrName[*AttrTop - 1], schema->Entries[j].Name);
					AttrName[*AttrTop - 1][l - 1] = '\0';
					//fprintf(stderr, "AttrName for leaf = %s\n", AttrName[*AttrTop - 1]);
				}
			}
			i = Clists[i].Next;
	    }
	    //*AttrTop = 0;
	    //fprintf(stderr, "i has become NIL\n");
	    return;
	}
	else {
	    i = TabExps[index].Select;
    	while (i != NIL) {
    		top = OpStackLists[Clists[i].Index].Top;
	    	bot = OpStackLists[Clists[i].Index].Bottom;
    		for (j = bot; j <= top; j++) {
	    		if (Ops[j].Val.Type == OPIDENT) {
/*
					for (k=0;k< *AttrTop;k++) {
						if (strcmp(AttrName[k],Identifiers[Ops[j].Val.Index].ColumnName) == 0)
							break;
					}
					if ( (*AttrTop == 0) || (strcmp(Identifiers[Ops[j].Val.Index].ColumnName, AttrName[k]) != 0) ){
							AttrName[(*AttrTop)++] = (char *)Malloc(strlen(Identifiers[Ops[j].Val.Index].ColumnName) + 1);
							strcpy(AttrName[*AttrTop - 1],Identifiers[Ops[j].Val.Index].ColumnName);
					}
*/
					AttrName[(*AttrTop)++] = (char *)Malloc(strlen(Identifiers[Ops[j].Val.Index].ColumnName) + 1);
					strcpy(AttrName[*AttrTop - 1],Identifiers[Ops[j].Val.Index].ColumnName);
	    		}
			}
			i = Clists[i].Next;
	    }
	}
}

int FindAncestor (schema, AncestorNumber, AncestorLevel, EntryNum)
	Schema *schema;
	int AncestorNumber, AncestorLevel, EntryNum;
{
	int i,j;
	
	/*printf("AncestorNumber = %d\n", AncestorNumber);
	printf("AncestorLevel  = %d\n", AncestorLevel);
	printf("EntryNum  = %d\n", EntryNum);*/
	
	for (i = 0; i < schema->NumberOfAttributes; i++)
	{
		j = AncestorLevel;
		//printf("i = %d\n", i);
		if ((schema->Entries[i].Number == AncestorNumber) &&
		    (schema->Entries[i].Level == AncestorLevel))
		{
			//printf("This entry's AncestorNumber and level match\n");
			for (j = AncestorLevel -1; j > 0; j--)
				if (schema->Entries[i].AncestorNumber[j] !=
				    schema->Entries[EntryNum].AncestorNumber[j])					break;
		}
		if (j == 0)
			break;
	}
	//printf("Value of i in FindAncestor %d\n", i);
	if (i >= schema->NumberOfAttributes)
		return -1;
	return i;
}
		
		






void DetermineWhereColumns	(Constants,Identifiers,Clists,Ops,OpStackLists,TabExps,
							index,AttrName,AttrTop,AttrsUsed,AttrsUsedTop,
							RelOp,ValUsed,LogOp,OSLindex)
	Constant			Constants[];
	Identifier			Identifiers[];
	ClistNode			Clists[];
	OpStack				Ops[];
	OpStackList			OpStackLists[];
	TabExp				TabExps[];
    unsigned int		index;
	char				*AttrName[];
	size_t				*AttrTop;
	char				*AttrsUsed[];
	size_t				*AttrsUsedTop;
	unsigned int		*RelOp;
	Constant			*ValUsed;
	unsigned int		*LogOp;
	unsigned int		OSLindex;
{
    unsigned int		i,j,k,l,top, bot,ptop,pbot;
	ptop = NIL;
	pbot = NIL;
    i = OSLindex;
    top = OpStackLists[i].Top;
    bot = OpStackLists[i].Bottom;
    
    //fprintf(stderr, "In DetermineWhere\n");

    for (j=0;j<i;j++) {
	if ( (OpStackLists[j].Bottom >= bot) &&
	(OpStackLists[j].Top <= top) &&
	(OpStackLists[j].Top != ptop) ) {
	   ptop = OpStackLists[j].Top;
	   for (k=OpStackLists[j].Bottom;k<=OpStackLists[j].Top;k++) {
	      if (Ops[OpStackLists[j].Top].Op <= LIK) {    
		/* LHS of Comparison */
		if (OpStackLists[j].Bottom == OpStackLists[j].Top) {      
		/* Good. Just a column*/
		  //fprintf(stderr, "Only one column to be compared");
		  if (Ops[k].Val.Type == OPIDENT) {
		     /*AttrsUsed[(*AttrsUsedTop)++] = 
				Identifiers[Ops[k].Val.Index].ColumnName;*/
		     AttrsUsed[(*AttrsUsedTop)++] = 
				(char *)Malloc(strlen(Identifiers[Ops[k].Val
					.Index].ColumnName) + 1);
		     //fprintf(stderr, "Only one column to be compared");
		     strcpy(AttrsUsed[*AttrsUsedTop - 1], 
				Identifiers[Ops[k].Val.Index].ColumnName);
		     //fprintf(stderr, "Only one column to be compared");
		     RelOp[*AttrsUsedTop - 1] = Ops[OpStackLists[j].Top].Op;
		  }
		  else {
		     //printf("Invalid Condition. No Column specified.\n");
	             //fprintf(stderr,"Invalid . No Column specified.\n");
		  }
		}
		else { /* IT's not just a column */		
		/* Scalar Expression. Add to Selected Columns.*/
		  if (Ops[k].Val.Type == OPIDENT) {
		     for (l=0;l<=*AttrTop;l++) {
  			if (AttrName[l] == 
				Identifiers[Ops[k].Val.Index].ColumnName)
			  if (strcmp(AttrName[l],
			  Identifiers[Ops[k].Val.Index].ColumnName) == 0)
			    break;
		     }
  		     if (Identifiers[Ops[k].Val.Index].ColumnName != 
				AttrName[l]) {
			if (strcmp(Identifiers[Ops[k].Val.Index].ColumnName, 
				AttrName[l]) != 0) {
			  AttrName[(*AttrTop)++] = 
				Identifiers[Ops[k].Val.Index].ColumnName;
			  AttrName[(*AttrTop)++] = 
				(char *)Malloc(strlen(Identifiers
				  [Ops[k].Val.Index].ColumnName) + 1);
		          strcpy(AttrName[*AttrTop - 1], 
				Identifiers[Ops[k].Val.Index].ColumnName);
			}
		     }
		   }
		   else;
		   }
		  }
		  else { /* RHS of Compare condition */
		   if ( (OpStackLists[j].Bottom == OpStackLists[j].Top) && 
		       (Ops[k].Val.Type == OPCONSTANT) ) {  
			/* Good. Just one */
		      switch (Constants[Ops[k].Val.Index].Type) {
			case STRINGCONS:
			   //fprintf(stderr, "Strings to be compared\n");
			   ValUsed[*AttrsUsedTop - 1].Type = STRINGCONS;
			   ValUsed[*AttrsUsedTop - 1].Val.String = (char*)Malloc(sizeof(char*)*strlen(Constants[Ops[k].Val.Index].Val.String) + 1);
			   strcpy(ValUsed[*AttrsUsedTop - 1].Val.String,
				Constants[Ops[k].Val.Index].Val.String);
			   //fprintf(stderr, "String to be compared = %s\n", ValUsed[*AttrsUsedTop-1].Val.String);
			   break;
			case INTEGERCONS:
			   ValUsed[*AttrsUsedTop - 1].Type = INTEGERCONS;
			   ValUsed[*AttrsUsedTop - 1].Val.Integer =
				Constants[Ops[k].Val.Index].Val.Integer;
			   break;
			case REALCONS:
			   ValUsed[*AttrsUsedTop - 1].Type = REALCONS;
			   ValUsed[*AttrsUsedTop - 1].Val.Real =
				Constants[Ops[k].Val.Index].Val.Real;
			   break;
			default:
			   //printf("Invalid data type.\n");
			   fprintf(stderr,"Invalid data type.\n");
		      }
		      LogOp[*AttrsUsedTop] = Ops[k].Op;
		  }
		  else {
		      *AttrsUsedTop = NIL;
		      break;
/*
		      RelOp[*AttrsUsedTop - 1] = NONE;
		      for (l=0;l<=*AttrTop;l++) {
		         if (AttrName[l] == 
				Identifiers[Ops[k].Val.Index].ColumnName)
			    break;
		      }
		      if (Identifiers[Ops[k].Val.Index].ColumnName != 
						AttrName[l]) {
			    AttrName[(*AttrTop)++] = 
				Identifiers[Ops[k].Val.Index].ColumnName;
		      }
		      LogOp[*AttrsUsedTop] = Ops[k].Op;
*/
		 }
		}
	     }
	     if (*AttrsUsedTop == NIL)
		break;
	}
	if (*AttrsUsedTop == NIL)
	     break;
     }
     //fprintf(stderr, "Returning from DetermineWhere\n");
}


int WhereExpressions	(Constants,Identifiers,Clists,Ops,OpStackLists,TabExps,
						index,AttrName,AttrTop,AttrsUsed,AttrsUsedTop,
						RelOp,ValUsed,LogOp,OSLindex, colslist, datalist)
	Constant			Constants[];
	Identifier			Identifiers[];
	ClistNode			Clists[];
	OpStack				Ops[];
	OpStackList			OpStackLists[];
	TabExp				TabExps[];
    unsigned int		index;
	char				*AttrName[];
	size_t				*AttrTop;
	char				*AttrsUsed[];
	size_t				*AttrsUsedTop;
	unsigned int		*RelOp;
	Constant			*ValUsed;
	unsigned int		*LogOp;
	unsigned int		OSLindex;
	q_cols				*colslist;
	q_data				*datalist;
{
    unsigned int		i,j,k,top, bot,ptop,pbot;
	ptop = NIL;
	pbot = NIL;
    i = OSLindex;
    top = OpStackLists[i].Top;
    bot = OpStackLists[i].Bottom;

	for (j=0;j<i;j++) {
		if ( (OpStackLists[j].Bottom >= bot) &&
			 (OpStackLists[j].Top <= top) &&
			 (OpStackLists[j].Top != ptop) ) {
			 ptop = OpStackLists[j].Top;
	
			for (k=OpStackLists[j].Bottom;k<=OpStackLists[j].Top;k++) {
				if (Ops[OpStackLists[j].Top].Op <= LIK) {    /* LHS of Comparison */
					if (OpStackLists[j].Bottom != OpStackLists[j].Top) {   /* Scalar Expression */
						if (Ops[k].Val.Type == OPIDENT) {
						}
					}
				}
				else { /* RHS of Compare condition */
					if ( (OpStackLists[j].Bottom != OpStackLists[j].Top) || (Ops[k].Val.Type != OPCONSTANT) ) {  /* Good. Just one */
						*AttrsUsedTop = NIL;
						break;
					}
				}
			}
		}
	}
}

/*char* strsep(char **pp, char *delim)
{
  char *p, *q;

  if (!(p = *pp))
    return 0;
  if ((q = strpbrk (p, delim)))
    {
      *pp = q + 1;
      *q = '\0';
    }
  else
    *pp = 0;
  return p;
}*/


