%{

/* qddb/Lib/LibQsql/SqlLex.l -- just a stub right now
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#include "Qddb.h"
#include "SqlParse.h"


/* Redefine the YY_DECL from yylex() to the needed yylex() with parameters
 * for bison's pure_parser directive.  This is very flex specific code,
 * so don't try to use lex with it!!
 */
#ifdef	YY_DECL
#	undef 		YY_DECL
#endif
#ifdef PRE3_4FLEX
#define YY_DECL		int SqlLex(yylvalp) \
				YYSTYPE		*yylvalp;
#else
#define YY_DECL		int SqlLex(yylvalp) \
				YYSTYPE		*yylvalp;
#endif

#ifdef yysqlwrap
#undef yysqlwrap
#endif


#if defined(YY_INPUT)
#undef YY_INPUT
#endif
#define YY_INPUT(buf, result, max_size) \
{ \
    char buf1[25] ;int c;\
    strcpy(buf1, "Select * From library");\
    buf1[21] = '\0';\
    c = Qddb_ReadBuffer(buf, (size_t)max_size); \
    result = (c == 0) ? YY_NULL : c; \
}


int yysqlwrap();
extern void Qddb_ResetSqlLex();

static int	LineNumber;

%}

a	[aA]
b	[bB]
c	[cC]
d	[dD]
e	[eE]
f	[fF]
g	[gG]
h	[hH]
i	[iI]
j	[jJ]
k	[kK]
l	[lL]
m	[mM]
n	[nN]
o	[oO]
p	[pP]
q	[qQ]
r	[rR]
s	[sS]
t	[tT]
u	[uU]
v	[vV]
w	[wW]
x	[xX]
y	[yY]
z	[zZ]

%%

{a}{n}{d}			return AND;
{o}{r}				return OR;

{d}{i}{s}{t}{i}{n}{c}{t}	return DISTINCT;

{i}{n}{s}{e}{r}{t}		return INSERT;
{i}{n}{t}{o}			return INTO;
{t}{u}{p}{l}{e}			return TUPLE;
{v}{a}{l}{u}{e}{s}		return VALUES;
{w}{h}{e}{r}{e}			return WHERE;
{f}{r}{o}{m}			return FROM;
{t}{a}{b}{l}{e}			return TABLE;
{v}{i}{e}{w}			return VIEW;

{s}{e}{l}{e}{c}{t}		return SELECT;

{c}{r}{e}{a}{t}{e}		return CREATE;
{d}{e}{l}{e}{t}{e}		return DELETE;
{u}{p}{d}{a}{t}{e}              return UPDATE;

{e}{x}{i}{s}{t}{s}              return EXISTS;
{n}{o}{t}                       return NOT;

{n}{u}{l}{l}                    return NULLVALUE;
{u}{n}{i}{q}{u}{e}              return UNIQUE;
{s}{c}{h}{e}{m}{a}              return SCHEMA;
{g}{r}{a}{n}{t}                 return GRANT;
{o}{n}                          return ON;
{t}{o}                          return TO;
{p}{u}{b}{l}{i}{c}              return PUBLIC;
{w}{i}{t}{h}                    return WITH;
{c}{h}{e}{c}{k}                 return CHECK;
{o}{p}{t}{i}{o}{n}		return OPTION;
{c}{l}{o}{s}{e}			return CLOSE;
{c}{o}{m}{m}{i}{t}		return COMMIT;
{w}{o}{r}{k}			return WORK;
{f}{e}{t}{c}{h}			return FETCH;
{c}{u}{r}{r}{e}{n}{t}		return CURRENT;
{o}{f}				return OF;
{a}{l}{l}			return ALL;
{o}{p}{e}{n}			return OPEN;
{s}{e}{t}			return SET;
{r}{o}{l}{l}{b}{a}{c}{k}	return ROLLBACK;
{u}{n}{i}{o}{n}			return UNION;
{g}{r}{o}{u}{p}			return GROUP;
{b}{y}				return BY;
{h}{a}{v}{i}{n}{g}		return HAVING;
{b}{e}{t}{w}{e}{e}{n}		return BETWEEN;
{i}{s}				return IS;
{l}{i}{k}{e}			return LIKE;

{i}{n}{d}{i}{c}{a}{t}{o}{r}     return INDICATOR;
{a}{u}{t}{h}{o}{r}{i}{z}{a}{t}{i}{o}{n}    return AUTHORIZATION;


{a}{v}{g}			return AVGFUNC;
{m}{a}{x}			return MAXFUNC;
{m}{i}{n}			return MINFUNC;
{s}{u}{m}			return SUMFUNC;
{c}{o}{u}{n}{t}			return COUNTFUNC;

{p}{r}{i}{v}{i}{l}{e}{g}{e}{s}	return PRIVILEGES;
{e}{s}{c}{a}{p}{e}		return ESCAPE;

{s}{t}{r}{i}{n}{g}		return STRINGTYPE;
{i}{n}{t}{e}{g}{e}{r}		return INTEGERTYPE;
{r}{e}{a}{l}			return REALTYPE;
{u}{n}{s}{i}{g}{n}{e}{d}	return UNSIGNEDTYPE;

{a}{n}{y}			return ANY;
{i}{n}				return IN;

"="				return EQ;
"<>"				return NE;
"<="				return LE;
"<"				return LT;
">="				return GE;
">"				return GT;

"/"				return DIV;
"+"				return PLUS;

","				return COMMA;

[a-zA-Z\_]+[a-zA-Z0-9\_\.]*	{ 
					/* This token must be before DOT
					 * so that identifiers will
					 * be recognized properly.
					 */			
    					yylvalp->string =
						Malloc(strlen(yytext)+1);
					strcpy(yylvalp->string, yytext);
					return IDENTIFIER;
				}

"."				return DOT;

"("				return LPAREN;
")"				return RPAREN;

\*                              return ASTERISK;
\t				;
\b				;
\n				LineNumber++;
\f				;
" "				;
"--".*                          ;
"-"                             return MINUS;


\-?[0-9]+"."[0-9]+[eE][0-9]+	{
					yylvalp->real = strtod(yytext, NULL);
					return REAL;
				}

\-?[0-9]+			{
					yylvalp->integer = atoi(yytext);
					return INTEGER;
				}

'[^\'\n]*\'			{
    					yylvalp->string =
						Malloc(strlen(yytext)+2);
					strcpy(yylvalp->string, yytext+1);
					yylvalp->	
					string[strlen(yylvalp->string)-1] 
						= '\0';
					return STRING;
				}




.				{ /*printf("syntax error: line number %d\n",
					LineNumber);*/
				}

%%

void Qddb_ResetSqlLex()
{
    if (yy_current_buffer)
        YY_FLUSH_BUFFER;
}

int yysqlwrap()
{
    //printf("Reached end of input\n");
    return 1;
}


#undef yyunput
#undef yy_push_state
#undef yy_pop_state
#undef yy_top_state

